/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.enviroment;

import com.aliyun.odps.account.Account;
import com.aliyun.odps.account.AppAccount;
import com.aliyun.odps.account.AppStsAccount;
import com.aliyun.odps.table.utils.Preconditions;
import java.util.Optional;

public class Credentials {
    private Account account;
    private AppAccount appAccount;
    private AppStsAccount appStsAccount;

    public Account getAccount() {
        return this.account;
    }

    public Optional<AppAccount> getAppAccount() {
        return Optional.ofNullable(this.appAccount);
    }

    public Optional<AppStsAccount> getAppStsAccount() {
        return Optional.ofNullable(this.appStsAccount);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final Credentials credentials = new Credentials();

        public Builder withAccount(Account account) {
            this.credentials.account = account;
            return this;
        }

        public Builder withAppAccount(AppAccount appAccount) {
            this.credentials.appAccount = appAccount;
            return this;
        }

        public Builder withAppStsAccount(AppStsAccount appStsAccount) {
            this.credentials.appStsAccount = appStsAccount;
            return this;
        }

        public Credentials build() {
            Preconditions.checkNotNull((Object)this.credentials.getAccount(), (String)"Odps account cannot be null");
            return this.credentials;
        }
    }
}

