/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.enviroment;

import com.aliyun.odps.table.enviroment.EnvironmentSettings;
import com.aliyun.odps.table.enviroment.ExecutionEnvironment;
import com.aliyun.odps.table.utils.Preconditions;
import com.aliyun.odps.utils.StringUtils;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalEnvironment
extends ExecutionEnvironment {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionEnvironment.class);
    private String localEndpoint = null;

    public LocalEnvironment(EnvironmentSettings settings) {
        super(settings);
    }

    @Override
    protected void initialize() {
        String port;
        String prefix;
        String mode = System.getenv("MAX_STORAGE_MODE");
        if (StringUtils.isNullOrEmpty((String)mode)) {
            logger.warn("Local env without maxstorage mode");
            return;
        }
        String confPath = System.getenv("MAX_STORAGE_DATA_PROXY_CONF_PATH");
        if (StringUtils.isNullOrEmpty((String)confPath)) {
            prefix = System.getenv("MAX_STORAGE_DATA_PROXY_PREFIX");
            port = System.getenv("MAX_STORAGE_DATA_PROXY_PORT");
        } else {
            port = System.getProperty("MAX_STORAGE_DATA_PROXY_PORT");
            if (!StringUtils.isNullOrEmpty((String)port)) {
                prefix = System.getProperty("MAX_STORAGE_DATA_PROXY_PREFIX");
            } else {
                try (FileInputStream fis = new FileInputStream(confPath);
                     BufferedInputStream bis = new BufferedInputStream(fis);){
                    JsonObject conf = new JsonParser().parse(new String(IOUtils.toByteArray((InputStream)bis))).getAsJsonObject();
                    if (conf.has("MAX_STORAGE_DATA_PROXY_PORT")) {
                        System.setProperty("MAX_STORAGE_DATA_PROXY_PORT", conf.get("MAX_STORAGE_DATA_PROXY_PORT").getAsString());
                    }
                    if (conf.has("MAX_STORAGE_DATA_PROXY_PREFIX")) {
                        System.setProperty("MAX_STORAGE_DATA_PROXY_PREFIX", conf.get("MAX_STORAGE_DATA_PROXY_PREFIX").getAsString());
                    }
                }
                catch (IOException e) {
                    logger.error("Local env find conf " + confPath + " failed!", (Throwable)e);
                    return;
                }
                prefix = System.getProperty("MAX_STORAGE_DATA_PROXY_PREFIX");
                port = System.getProperty("MAX_STORAGE_DATA_PROXY_PORT");
            }
        }
        Preconditions.checkString((String)port, (String)"MAX_STORAGE_DATA_PROXY_PORT");
        String localHostPort = StringUtils.isNullOrEmpty((String)prefix) ? "http://127.0.0.1:" + port : "http://127.0.0.1:" + port + "/" + prefix;
        this.localEndpoint = localHostPort;
    }

    @Override
    public String getTunnelEndpoint(String targetProject) {
        this.ensureInitialized();
        return Optional.ofNullable(this.localEndpoint).orElseGet(() -> this.settings.getTunnelEndpoint().orElseThrow(() -> new IllegalStateException("Local environment get empty tunnel endpoint!")));
    }
}

