/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.optimizer.predicate;

import com.aliyun.odps.table.optimizer.predicate.Predicate;
import java.io.Serializable;

public class BinaryPredicate
extends Predicate {
    private final Operator operator;
    private final Serializable leftOperand;
    private final Serializable rightOperand;

    public BinaryPredicate(Operator operator, Serializable leftOperand, Serializable rightOperand) {
        super(Predicate.PredicateType.BINARY);
        this.operator = operator;
        this.leftOperand = leftOperand;
        this.rightOperand = rightOperand;
    }

    public static BinaryPredicate equals(Serializable leftOperand, Serializable rightOperand) {
        return new BinaryPredicate(Operator.EQUALS, leftOperand, rightOperand);
    }

    public static BinaryPredicate notEquals(Serializable leftOperand, Serializable rightOperand) {
        return new BinaryPredicate(Operator.NOT_EQUALS, leftOperand, rightOperand);
    }

    public static BinaryPredicate greaterThan(Serializable leftOperand, Serializable rightOperand) {
        return new BinaryPredicate(Operator.GREATER_THAN, leftOperand, rightOperand);
    }

    public static BinaryPredicate lessThan(Serializable leftOperand, Serializable rightOperand) {
        return new BinaryPredicate(Operator.LESS_THAN, leftOperand, rightOperand);
    }

    public static BinaryPredicate greaterThanOrEqual(Serializable leftOperand, Serializable rightOperand) {
        return new BinaryPredicate(Operator.GREATER_THAN_OR_EQUAL, leftOperand, rightOperand);
    }

    public static BinaryPredicate lessThanOrEqual(Serializable leftOperand, Serializable rightOperand) {
        return new BinaryPredicate(Operator.LESS_THAN_OR_EQUAL, leftOperand, rightOperand);
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Object getLeftOperand() {
        return this.leftOperand;
    }

    public Object getRightOperand() {
        return this.rightOperand;
    }

    @Override
    public String toString() {
        return this.leftOperand.toString() + " " + this.operator.getDescription() + " " + this.rightOperand.toString();
    }

    public static enum Operator {
        EQUALS("="),
        NOT_EQUALS("!="),
        GREATER_THAN(">"),
        LESS_THAN("<"),
        GREATER_THAN_OR_EQUAL(">="),
        LESS_THAN_OR_EQUAL("<=");

        private final String description;

        private Operator(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

