/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.optimizer.predicate;

import com.aliyun.odps.table.optimizer.predicate.Predicate;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class CompoundPredicate
extends Predicate {
    private final Operator logicalOperator;
    private final List<Predicate> predicates;

    public CompoundPredicate(Operator logicalOperator) {
        this(logicalOperator, new ArrayList<Predicate>());
    }

    public CompoundPredicate(Operator logicalOperator, List<Predicate> predicates) {
        super(Predicate.PredicateType.COMPOUND);
        this.logicalOperator = logicalOperator;
        this.predicates = predicates;
        if (logicalOperator == Operator.NOT && predicates.size() > 1) {
            throw new IllegalArgumentException("NOT operator should only have one operand");
        }
    }

    public static CompoundPredicate and(Predicate ... predicates) {
        return new CompoundPredicate(Operator.AND, Arrays.stream(predicates).collect(Collectors.toList()));
    }

    public static CompoundPredicate or(Predicate ... predicates) {
        return new CompoundPredicate(Operator.OR, Arrays.stream(predicates).collect(Collectors.toList()));
    }

    public static CompoundPredicate not(Predicate predicates) {
        return new CompoundPredicate(Operator.NOT, (List<Predicate>)ImmutableList.of((Object)predicates));
    }

    public void addPredicate(Predicate predicate) {
        this.predicates.add(predicate);
    }

    @Override
    public String toString() {
        if (this.predicates.isEmpty()) {
            return Predicate.NO_PREDICATE.toString();
        }
        String opStr = this.logicalOperator.getDescription();
        StringBuilder sb = new StringBuilder();
        if (this.logicalOperator == Operator.NOT) {
            Predicate predicate = this.predicates.get(0);
            if (!this.validatePredicate(predicate)) {
                return Predicate.NO_PREDICATE.toString();
            }
            sb.append(opStr).append(" ");
            if (predicate instanceof CompoundPredicate) {
                sb.append('(').append(predicate).append(')');
            } else {
                sb.append(predicate.toString());
            }
            return sb.toString();
        }
        for (int i = 0; i < this.predicates.size(); ++i) {
            Predicate currentPredicate = this.predicates.get(i);
            if (!this.validatePredicate(currentPredicate)) {
                if (this.logicalOperator != Operator.OR) continue;
                return Predicate.NO_PREDICATE.toString();
            }
            if (currentPredicate instanceof CompoundPredicate && ((CompoundPredicate)currentPredicate).logicalOperator != this.logicalOperator) {
                sb.append('(').append(currentPredicate).append(')');
            } else {
                sb.append(currentPredicate.toString());
            }
            if (i >= this.predicates.size() - 1) continue;
            sb.append(" ").append(opStr).append(" ");
        }
        return sb.toString();
    }

    public static enum Operator {
        AND("and"),
        OR("or"),
        NOT("not");

        private final String description;

        private Operator(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

