/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.optimizer.predicate;

import com.aliyun.odps.table.optimizer.predicate.Predicate;
import java.io.Serializable;
import java.util.List;

public class InPredicate
extends Predicate {
    private final Operator operator;
    private final Serializable operand;
    private final List<Serializable> set;

    public InPredicate(Operator operator, Serializable operand, List<Serializable> set) {
        super(Predicate.PredicateType.IN);
        this.operator = operator;
        this.operand = operand;
        this.set = set;
    }

    public static InPredicate in(Serializable operand, List<Serializable> set) {
        return new InPredicate(Operator.IN, operand, set);
    }

    public static InPredicate notIn(Serializable operand, List<Serializable> set) {
        return new InPredicate(Operator.NOT_IN, operand, set);
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Object getOperand() {
        return this.operand;
    }

    public List<Serializable> getSet() {
        return this.set;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.operand).append(" ").append(this.operator.getDescription()).append(" (");
        for (int i = 0; i < this.set.size(); ++i) {
            sb.append(this.set.get(i).toString());
            if (i >= this.set.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public static enum Operator {
        IN("in"),
        NOT_IN("not in");

        private final String description;

        private Operator(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

