/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.read;

import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.Table;
import com.aliyun.odps.table.TableIdentifier;
import com.aliyun.odps.table.configuration.ArrowOptions;
import com.aliyun.odps.table.configuration.SplitOptions;
import com.aliyun.odps.table.enviroment.EnvironmentSettings;
import com.aliyun.odps.table.optimizer.predicate.Predicate;
import com.aliyun.odps.table.read.TableBatchReadSession;
import com.aliyun.odps.table.read.TableReadSessionProvider;
import com.aliyun.odps.table.read.impl.TableReadSessionProviderImpl;
import com.aliyun.odps.table.utils.SessionUtils;
import java.io.IOException;
import java.util.List;

public class TableReadSessionBuilder {
    private TableIdentifier identifier;
    private List<String> requiredDataColumns;
    private List<String> requiredPartitionColumns;
    private List<PartitionSpec> requiredPartitions;
    private List<Integer> requiredBucketIds;
    private SplitOptions splitOptions;
    private ArrowOptions arrowOptions;
    private EnvironmentSettings settings;
    private String sessionId;
    private String sessionProvider;
    private Predicate filterPredicate;

    public TableReadSessionBuilder table(Table table) {
        this.identifier = TableIdentifier.of((String)table.getProject(), (String)table.getSchemaName(), (String)table.getName());
        return this;
    }

    public TableReadSessionBuilder identifier(TableIdentifier identifier) {
        this.identifier = identifier;
        return this;
    }

    public TableReadSessionBuilder requiredDataColumns(List<String> requiredDataColumns) {
        this.requiredDataColumns = requiredDataColumns;
        return this;
    }

    public TableReadSessionBuilder requiredPartitionColumns(List<String> requiredPartitionColumns) {
        this.requiredPartitionColumns = requiredPartitionColumns;
        return this;
    }

    public TableReadSessionBuilder requiredPartitions(List<PartitionSpec> requiredPartitions) {
        this.requiredPartitions = requiredPartitions;
        return this;
    }

    public TableReadSessionBuilder requiredBucketIds(List<Integer> requiredBucketIds) {
        this.requiredBucketIds = requiredBucketIds;
        return this;
    }

    public TableReadSessionBuilder withSplitOptions(SplitOptions splitOptions) {
        this.splitOptions = splitOptions;
        return this;
    }

    public TableReadSessionBuilder withArrowOptions(ArrowOptions arrowOptions) {
        this.arrowOptions = arrowOptions;
        return this;
    }

    public TableReadSessionBuilder withSettings(EnvironmentSettings settings) {
        this.settings = settings;
        return this;
    }

    public TableReadSessionBuilder withSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public TableReadSessionBuilder withSessionProvider(String provider) {
        this.sessionProvider = provider;
        return this;
    }

    public TableReadSessionBuilder withFilterPredicate(Predicate filterPredicate) {
        this.filterPredicate = filterPredicate;
        return this;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public SplitOptions getSplitOptions() {
        return this.splitOptions;
    }

    public TableIdentifier getIdentifier() {
        return this.identifier;
    }

    public List<Integer> getRequiredBucketIds() {
        return this.requiredBucketIds;
    }

    public List<String> getRequiredDataColumns() {
        return this.requiredDataColumns;
    }

    public ArrowOptions getArrowOptions() {
        return this.arrowOptions;
    }

    public EnvironmentSettings getSettings() {
        return this.settings;
    }

    public List<PartitionSpec> getRequiredPartitions() {
        return this.requiredPartitions;
    }

    public List<String> getRequiredPartitionColumns() {
        return this.requiredPartitionColumns;
    }

    public Predicate getFilterPredicate() {
        return this.filterPredicate;
    }

    public TableBatchReadSession buildBatchReadSession() throws IOException {
        return this.getProvider().createBatchReadSession(this);
    }

    private TableReadSessionProvider getProvider() throws IOException {
        try {
            return this.sessionProvider != null ? SessionUtils.discoverSessionProvider(TableReadSessionBuilder.class.getClassLoader(), TableReadSessionProvider.class, this.sessionProvider) : new TableReadSessionProviderImpl();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(String.format("Unable to create a table batch read session for reading table '%s'.\n\nSession provider are:\n\n%s", this.identifier.toString(), this.sessionProvider), e);
        }
    }
}

