/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.read.split.impl;

import com.aliyun.odps.table.read.split.InputSplitWithIndex;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class IndexedInputSplit
implements InputSplitWithIndex {
    private static final long serialVersionUID = 1L;
    private final String sessionId;
    private final int splitIndex;

    public IndexedInputSplit(String sessionId, int index) {
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (Object)"index must be >= 0");
        this.sessionId = (String)Preconditions.checkNotNull((Object)sessionId);
        this.splitIndex = index;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public int getSplitIndex() {
        return this.splitIndex;
    }

    public int hashCode() {
        return Objects.hash(this.splitIndex);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof IndexedInputSplit) {
            IndexedInputSplit other = (IndexedInputSplit)obj;
            return other.splitIndex == this.splitIndex && other.sessionId.equals(this.sessionId);
        }
        return false;
    }

    public String toString() {
        return String.format("IndexedInputSplit: SessionId=%s SplitIndex=%s", this.sessionId, this.splitIndex);
    }
}

