/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.read.split.impl;

import com.aliyun.odps.table.read.split.InputSplit;
import com.aliyun.odps.table.read.split.InputSplitAssigner;
import com.aliyun.odps.table.read.split.impl.IndexedInputSplit;

public class IndexedInputSplitAssigner
implements InputSplitAssigner {
    private final int totalSplitCount;
    private final String sessionId;

    public IndexedInputSplitAssigner(String sessionId, int totalSplitCount) {
        this.sessionId = sessionId;
        this.totalSplitCount = totalSplitCount;
    }

    @Override
    public int getSplitsCount() {
        return this.totalSplitCount;
    }

    @Override
    public InputSplit getSplit(int index) {
        if (index >= this.totalSplitCount) {
            throw new IllegalArgumentException("Index of input split exceed max count");
        }
        return new IndexedInputSplit(this.sessionId, index);
    }

    @Override
    public InputSplit[] getAllSplits() {
        InputSplit[] splits = new IndexedInputSplit[this.totalSplitCount];
        for (int i = 0; i < this.totalSplitCount; ++i) {
            splits[i] = new IndexedInputSplit(this.sessionId, i);
        }
        return splits;
    }
}

