/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.record.constructor;

import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.OdpsTypeTransformer;
import com.aliyun.odps.data.Struct;
import com.aliyun.odps.table.arrow.constructor.ArrowDateDayWriter;
import java.sql.Date;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.List;
import org.apache.arrow.vector.DateDayVector;

public class ArrowDateDayWriterImpl {
    private static int transformToEpochDay(Object date) {
        LocalDate localDate = date instanceof LocalDate ? (LocalDate)date : OdpsTypeTransformer.dateToLocalDate((Date)((Date)date), (Calendar)ArrayRecord.DEFAULT_CALENDAR);
        return Math.toIntExact(localDate.toEpochDay());
    }

    public static final class StructDateWriter
    extends ArrowDateDayWriter<Struct> {
        StructDateWriter(DateDayVector dateDayVector) {
            super(dateDayVector);
        }

        @Override
        protected boolean isNullAt(Struct in, int ordinal) {
            return in.getFieldValue(ordinal) == null;
        }

        @Override
        protected int readEpochDay(Struct in, int ordinal) {
            return ArrowDateDayWriterImpl.transformToEpochDay(in.getFieldValue(ordinal));
        }
    }

    public static final class ListDateWriter
    extends ArrowDateDayWriter<List<Object>> {
        ListDateWriter(DateDayVector DateVector) {
            super(DateVector);
        }

        @Override
        protected boolean isNullAt(List<Object> in, int ordinal) {
            return in.get(ordinal) == null;
        }

        @Override
        protected int readEpochDay(List<Object> in, int ordinal) {
            return ArrowDateDayWriterImpl.transformToEpochDay(in.get(ordinal));
        }
    }

    public static final class RecordDateWriter
    extends ArrowDateDayWriter<ArrayRecord> {
        RecordDateWriter(DateDayVector dateDayVector) {
            super(dateDayVector);
        }

        @Override
        protected boolean isNullAt(ArrayRecord row, int ordinal) {
            return row.isNull(ordinal);
        }

        @Override
        protected int readEpochDay(ArrayRecord row, int ordinal) {
            return ArrowDateDayWriterImpl.transformToEpochDay(row.get(ordinal));
        }
    }
}

