/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.record.constructor;

import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Struct;
import com.aliyun.odps.table.arrow.constructor.ArrowTimeStampWriter;
import com.google.common.base.Preconditions;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import org.apache.arrow.vector.TimeStampVector;
import org.apache.arrow.vector.types.TimeUnit;

public class ArrowDateTimeWriterImpl {
    private static long transformToEpochTime(Object datetime) {
        long longValue = datetime instanceof ZonedDateTime ? ((ZonedDateTime)datetime).toInstant().toEpochMilli() : ((Date)datetime).getTime();
        return longValue;
    }

    public static final class StructDateTimeWriter
    extends ArrowTimeStampWriter<Struct> {
        StructDateTimeWriter(TimeStampVector timeStampVector) {
            super(timeStampVector);
        }

        @Override
        protected long readEpochTime(Struct row, int ordinal) {
            return ArrowDateTimeWriterImpl.transformToEpochTime(row.getFieldValue(ordinal));
        }

        @Override
        protected boolean isNullAt(Struct in, int ordinal) {
            return in.getFieldValue(ordinal) == null;
        }
    }

    public static final class ListDateTimeWriter
    extends ArrowTimeStampWriter<List<Object>> {
        ListDateTimeWriter(TimeStampVector timeStampVector) {
            super(timeStampVector);
        }

        @Override
        protected long readEpochTime(List<Object> row, int ordinal) {
            return ArrowDateTimeWriterImpl.transformToEpochTime(row.get(ordinal));
        }

        @Override
        protected boolean isNullAt(List<Object> in, int ordinal) {
            return in.get(ordinal) == null;
        }
    }

    public static final class RecordDateTimeWriter
    extends ArrowTimeStampWriter<ArrayRecord> {
        RecordDateTimeWriter(TimeStampVector timeStampVector) {
            super(timeStampVector);
            Preconditions.checkState((boolean)this.getType().getUnit().equals((Object)TimeUnit.MILLISECOND));
        }

        @Override
        protected long readEpochTime(ArrayRecord row, int ordinal) {
            return ArrowDateTimeWriterImpl.transformToEpochTime(row.get(ordinal));
        }

        @Override
        protected boolean isNullAt(ArrayRecord row, int ordinal) {
            return row.isNull(ordinal);
        }
    }
}

