/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.record.constructor;

import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Struct;
import com.aliyun.odps.table.arrow.constructor.ArrowDecimalWriter;
import com.aliyun.odps.type.DecimalTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import java.math.BigDecimal;
import java.util.List;
import org.apache.arrow.vector.DecimalVector;

public class ArrowDecimalWriterImpl {

    public static final class StructDecimalWriter
    extends ArrowDecimalWriter<Struct> {
        StructDecimalWriter(DecimalVector decimalVector, TypeInfo typeInfo) {
            super(decimalVector, ((DecimalTypeInfo)typeInfo).getPrecision(), ((DecimalTypeInfo)typeInfo).getScale());
        }

        @Override
        protected boolean isNullAt(Struct in, int ordinal) {
            return in.getFieldValue(ordinal) == null;
        }

        @Override
        protected BigDecimal readBigDecimal(Struct in, int ordinal) {
            return (BigDecimal)in.getFieldValue(ordinal);
        }
    }

    public static final class ListDecimalWriter
    extends ArrowDecimalWriter<List<Object>> {
        ListDecimalWriter(DecimalVector decimalVector, TypeInfo typeInfo) {
            super(decimalVector, ((DecimalTypeInfo)typeInfo).getPrecision(), ((DecimalTypeInfo)typeInfo).getScale());
        }

        @Override
        protected boolean isNullAt(List<Object> in, int ordinal) {
            return in.get(ordinal) == null;
        }

        @Override
        protected BigDecimal readBigDecimal(List<Object> in, int ordinal) {
            return (BigDecimal)in.get(ordinal);
        }
    }

    public static final class RecordDecimalWriter
    extends ArrowDecimalWriter<ArrayRecord> {
        RecordDecimalWriter(DecimalVector decimalVector, TypeInfo typeInfo) {
            super(decimalVector, ((DecimalTypeInfo)typeInfo).getPrecision(), ((DecimalTypeInfo)typeInfo).getScale());
        }

        @Override
        protected boolean isNullAt(ArrayRecord row, int ordinal) {
            return row.isNull(ordinal);
        }

        @Override
        protected BigDecimal readBigDecimal(ArrayRecord row, int ordinal) {
            return row.getDecimal(ordinal);
        }
    }
}

