/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.record.constructor;

import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Struct;
import com.aliyun.odps.table.arrow.constructor.ArrowMapWriter;
import com.aliyun.odps.table.record.constructor.ArrowArrayWriterImpl;
import com.aliyun.odps.type.MapTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.StructVector;

public class ArrowMapWriterImpl {

    public static final class StructMapWriter
    extends ArrowMapWriterBase<Struct> {
        StructMapWriter(MapVector mapVector, TypeInfo typeInfo) {
            super(mapVector, typeInfo);
        }

        @Override
        protected Map<Object, Object> readMap(Struct struct, int ordinal) {
            return (Map)struct.getFieldValue(ordinal);
        }

        @Override
        protected boolean isNullAt(Struct in, int ordinal) {
            return in.getFieldValue(ordinal) == null;
        }
    }

    public static final class ListMapWriter
    extends ArrowMapWriterBase<List<Object>> {
        ListMapWriter(MapVector mapVector, TypeInfo typeInfo) {
            super(mapVector, typeInfo);
        }

        @Override
        protected Map<Object, Object> readMap(List<Object> in, int ordinal) {
            return (Map)in.get(ordinal);
        }

        @Override
        protected boolean isNullAt(List<Object> in, int ordinal) {
            return in.get(ordinal) == null;
        }
    }

    public static final class RecordMapWriter
    extends ArrowMapWriterBase<ArrayRecord> {
        RecordMapWriter(MapVector mapVector, TypeInfo typeInfo) {
            super(mapVector, typeInfo);
        }

        @Override
        protected Map<Object, Object> readMap(ArrayRecord record, int ordinal) {
            return record.getMap(ordinal);
        }

        @Override
        protected boolean isNullAt(ArrayRecord row, int ordinal) {
            return row.isNull(ordinal);
        }
    }

    public static abstract class ArrowMapWriterBase<IN>
    extends ArrowMapWriter<IN, Map<Object, Object>, List<Object>, List<Object>> {
        ArrowMapWriterBase(MapVector mapVector, TypeInfo typeInfo) {
            super(mapVector, ArrowArrayWriterImpl.createArrowFieldWriterForList((ValueVector)((StructVector)mapVector.getDataVector()).getChild("key"), ((MapTypeInfo)typeInfo).getKeyTypeInfo()), ArrowArrayWriterImpl.createArrowFieldWriterForList((ValueVector)((StructVector)mapVector.getDataVector()).getChild("value"), ((MapTypeInfo)typeInfo).getValueTypeInfo()));
        }

        @Override
        protected int numElements(Map<Object, Object> arrayData) {
            return arrayData.size();
        }

        @Override
        protected List<Object> readKeyArray(Map<Object, Object> mapData) {
            ArrayList<Object> keyArray = new ArrayList<Object>();
            mapData.forEach((key, value) -> keyArray.add(key));
            return keyArray;
        }

        @Override
        protected List<Object> readValueArray(Map<Object, Object> mapData) {
            ArrayList<Object> valueArray = new ArrayList<Object>();
            mapData.forEach((key, value) -> valueArray.add(value));
            return valueArray;
        }
    }
}

