/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.record.constructor;

import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Struct;
import com.aliyun.odps.table.arrow.constructor.ArrowFieldWriter;
import com.aliyun.odps.table.arrow.constructor.ArrowStructWriter;
import com.aliyun.odps.table.record.constructor.ArrowArrayWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowBigIntWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowBitWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowDateDayWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowDateTimeWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowDecimalWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowFloat4WriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowFloat8WriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowIntWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowMapWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowSmallIntWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowTimeStampWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowTinyIntWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowVarBinaryWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowVarCharWriterImpl;
import com.aliyun.odps.type.StructTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import java.util.List;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeStampVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.StructVector;

public class ArrowStructWriterImpl {
    public static ArrowFieldWriter<Struct>[] createArrowFieldWritersForStruct(StructVector structVector, StructTypeInfo typeInfo) {
        if (structVector.getChildFieldNames().size() != typeInfo.getFieldCount()) {
            throw new RuntimeException();
        }
        ArrowFieldWriter[] fieldsWriters = new ArrowFieldWriter[structVector.getChildFieldNames().size()];
        for (int i = 0; i < structVector.getChildFieldNames().size(); ++i) {
            if (!((String)structVector.getChildFieldNames().get(i)).equals(typeInfo.getFieldNames().get(i))) {
                throw new RuntimeException();
            }
            fieldsWriters[i] = ArrowStructWriterImpl.createArrowFieldWriterForStruct(structVector.getChildByOrdinal(i), (TypeInfo)typeInfo.getFieldTypeInfos().get(i));
        }
        return fieldsWriters;
    }

    public static ArrowFieldWriter<Struct> createArrowFieldWriterForStruct(ValueVector vector, TypeInfo typeInfo) {
        switch (typeInfo.getOdpsType()) {
            case BOOLEAN: {
                return new ArrowBitWriterImpl.StructBitWriter((BitVector)vector);
            }
            case TINYINT: {
                return new ArrowTinyIntWriterImpl.StructTinyIntWriter((TinyIntVector)vector);
            }
            case SMALLINT: {
                return new ArrowSmallIntWriterImpl.StructSmallIntWriter((SmallIntVector)vector);
            }
            case INT: {
                return new ArrowIntWriterImpl.StructIntWriter((IntVector)vector);
            }
            case BIGINT: {
                return new ArrowBigIntWriterImpl.StructBigIntWriter((BigIntVector)vector);
            }
            case FLOAT: {
                return new ArrowFloat4WriterImpl.StructFloat4Writer((Float4Vector)vector);
            }
            case DOUBLE: {
                return new ArrowFloat8WriterImpl.StructFloat8Writer((Float8Vector)vector);
            }
            case DECIMAL: {
                return new ArrowDecimalWriterImpl.StructDecimalWriter((DecimalVector)vector, typeInfo);
            }
            case STRING: 
            case VARCHAR: 
            case CHAR: 
            case JSON: {
                return new ArrowVarCharWriterImpl.StructVarCharWriter((VarCharVector)vector);
            }
            case BINARY: {
                return new ArrowVarBinaryWriterImpl.StructVarBinaryWriter((VarBinaryVector)vector);
            }
            case DATE: {
                return new ArrowDateDayWriterImpl.StructDateWriter((DateDayVector)vector);
            }
            case DATETIME: {
                return new ArrowDateTimeWriterImpl.StructDateTimeWriter((TimeStampVector)vector);
            }
            case TIMESTAMP: 
            case TIMESTAMP_NTZ: {
                return new ArrowTimeStampWriterImpl.StructTimeStampWriter((TimeStampVector)vector, typeInfo);
            }
            case ARRAY: {
                return new ArrowArrayWriterImpl.StructArrayWriter((ListVector)vector, typeInfo);
            }
            case MAP: {
                return new ArrowMapWriterImpl.StructMapWriter((MapVector)vector, typeInfo);
            }
            case STRUCT: {
                return new StructArrowStructWriter((StructVector)vector, typeInfo);
            }
        }
        throw new UnsupportedOperationException("Datatype not supported: " + typeInfo.getTypeName());
    }

    public static final class StructArrowStructWriter
    extends ArrowStructWriterBase<Struct> {
        StructArrowStructWriter(StructVector structVector, TypeInfo typeInfo) {
            super(structVector, typeInfo);
        }

        @Override
        protected Struct readStruct(Struct struct, int ordinal) {
            return (Struct)struct.getFieldValue(ordinal);
        }

        @Override
        protected boolean isNullAt(Struct in, int ordinal) {
            return in.getFieldValue(ordinal) == null;
        }
    }

    public static final class ListStructWriter
    extends ArrowStructWriterBase<List<Object>> {
        ListStructWriter(StructVector structVector, TypeInfo typeInfo) {
            super(structVector, typeInfo);
        }

        @Override
        protected Struct readStruct(List<Object> in, int ordinal) {
            return (Struct)in.get(ordinal);
        }

        @Override
        protected boolean isNullAt(List<Object> in, int ordinal) {
            return in.get(ordinal) == null;
        }
    }

    public static final class RecordStructWriter
    extends ArrowStructWriterBase<ArrayRecord> {
        RecordStructWriter(StructVector structVector, TypeInfo typeInfo) {
            super(structVector, typeInfo);
        }

        @Override
        protected Struct readStruct(ArrayRecord record, int ordinal) {
            return record.getStruct(ordinal);
        }

        @Override
        protected boolean isNullAt(ArrayRecord row, int ordinal) {
            return row.isNull(ordinal);
        }
    }

    public static abstract class ArrowStructWriterBase<IN>
    extends ArrowStructWriter<IN, Struct> {
        ArrowStructWriterBase(StructVector structVector, TypeInfo typeInfo) {
            super(structVector, ArrowStructWriterImpl.createArrowFieldWritersForStruct(structVector, (StructTypeInfo)typeInfo));
        }

        @Override
        protected abstract Struct readStruct(IN var1, int var2);
    }
}

