/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.record.constructor;

import com.aliyun.odps.OdpsType;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Struct;
import com.aliyun.odps.table.arrow.constructor.ArrowTimeStampWriter;
import com.aliyun.odps.type.TypeInfo;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import org.apache.arrow.vector.TimeStampVector;
import org.apache.arrow.vector.types.TimeUnit;

public class ArrowTimeStampWriterImpl {
    private static long transformToEpochTime(Object timestamp, TimeUnit unit, OdpsType odpsType) {
        Instant instant;
        if (odpsType.equals((Object)OdpsType.TIMESTAMP)) {
            instant = timestamp instanceof Instant ? (Instant)timestamp : ((Timestamp)timestamp).toInstant();
        } else if (odpsType.equals((Object)OdpsType.TIMESTAMP_NTZ)) {
            instant = ((LocalDateTime)timestamp).toInstant(ZoneOffset.UTC);
        } else {
            throw new UnsupportedOperationException("Unsupported odps type: " + odpsType);
        }
        return ArrowTimeStampWriterImpl.instantToEpochTime(instant, unit);
    }

    public static long instantToNanos(Instant instant) {
        long secs = instant.getEpochSecond();
        long nanos = instant.getNano();
        if (secs < 0L && nanos > 0L) {
            long us = Math.multiplyExact(secs + 1L, 1000000000L);
            return Math.addExact(us, nanos - 1000000000L);
        }
        long us = Math.multiplyExact(secs, 1000000000L);
        return Math.addExact(us, nanos);
    }

    public static long instantToMicros(Instant instant) {
        long secs = instant.getEpochSecond();
        long nanos = instant.getNano();
        if (secs < 0L && nanos > 0L) {
            long us = Math.multiplyExact(secs + 1L, 1000000L);
            return Math.addExact(us, java.util.concurrent.TimeUnit.NANOSECONDS.toMicros(nanos) - 1000000L);
        }
        long us = Math.multiplyExact(secs, 1000000L);
        return Math.addExact(us, java.util.concurrent.TimeUnit.NANOSECONDS.toMicros(nanos));
    }

    public static long instantToEpochTime(Instant instant, TimeUnit unit) {
        switch (unit) {
            case SECOND: {
                return instant.getEpochSecond();
            }
            case MILLISECOND: {
                return instant.toEpochMilli();
            }
            case MICROSECOND: {
                return ArrowTimeStampWriterImpl.instantToMicros(instant);
            }
            case NANOSECOND: {
                return ArrowTimeStampWriterImpl.instantToNanos(instant);
            }
        }
        throw new UnsupportedOperationException("Unit not supported: " + unit);
    }

    public static final class StructTimeStampWriter
    extends ArrowTimeStampWriter<Struct> {
        private final TypeInfo odpsTypeInfo;

        StructTimeStampWriter(TimeStampVector timeStampVector, TypeInfo typeInfo) {
            super(timeStampVector);
            this.odpsTypeInfo = typeInfo;
        }

        @Override
        protected long readEpochTime(Struct row, int ordinal) {
            return ArrowTimeStampWriterImpl.transformToEpochTime(row.getFieldValue(ordinal), this.getType().getUnit(), this.odpsTypeInfo.getOdpsType());
        }

        @Override
        protected boolean isNullAt(Struct in, int ordinal) {
            return in.getFieldValue(ordinal) == null;
        }
    }

    public static final class ListTimeStampWriter
    extends ArrowTimeStampWriter<List<Object>> {
        private final TypeInfo odpsTypeInfo;

        ListTimeStampWriter(TimeStampVector timeStampVector, TypeInfo typeInfo) {
            super(timeStampVector);
            this.odpsTypeInfo = typeInfo;
        }

        @Override
        protected long readEpochTime(List<Object> row, int ordinal) {
            return ArrowTimeStampWriterImpl.transformToEpochTime(row.get(ordinal), this.getType().getUnit(), this.odpsTypeInfo.getOdpsType());
        }

        @Override
        protected boolean isNullAt(List<Object> in, int ordinal) {
            return in.get(ordinal) == null;
        }
    }

    public static final class RecordTimeStampWriter
    extends ArrowTimeStampWriter<ArrayRecord> {
        private final TypeInfo odpsTypeInfo;

        RecordTimeStampWriter(TimeStampVector timeStampVector, TypeInfo typeInfo) {
            super(timeStampVector);
            this.odpsTypeInfo = typeInfo;
        }

        @Override
        protected long readEpochTime(ArrayRecord row, int ordinal) {
            return ArrowTimeStampWriterImpl.transformToEpochTime(row.get(ordinal), this.getType().getUnit(), this.odpsTypeInfo.getOdpsType());
        }

        @Override
        protected boolean isNullAt(ArrayRecord row, int ordinal) {
            return row.isNull(ordinal);
        }
    }
}

