/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.record.constructor;

import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Struct;
import com.aliyun.odps.table.arrow.constructor.ArrowTinyIntWriter;
import java.util.List;
import org.apache.arrow.vector.TinyIntVector;

public class ArrowTinyIntWriterImpl {

    public static final class StructTinyIntWriter
    extends ArrowTinyIntWriter<Struct> {
        StructTinyIntWriter(TinyIntVector tinyIntVector) {
            super(tinyIntVector);
        }

        @Override
        protected boolean isNullAt(Struct in, int ordinal) {
            return in.getFieldValue(ordinal) == null;
        }

        @Override
        protected byte readByte(Struct in, int ordinal) {
            return (Byte)in.getFieldValue(ordinal);
        }
    }

    public static final class ListTinyIntWriter
    extends ArrowTinyIntWriter<List<Object>> {
        ListTinyIntWriter(TinyIntVector tinyIntVector) {
            super(tinyIntVector);
        }

        @Override
        protected boolean isNullAt(List<Object> in, int ordinal) {
            return in.get(ordinal) == null;
        }

        @Override
        protected byte readByte(List<Object> in, int ordinal) {
            return (Byte)in.get(ordinal);
        }
    }

    public static final class RecordTinyIntWriter
    extends ArrowTinyIntWriter<ArrayRecord> {
        RecordTinyIntWriter(TinyIntVector tinyIntVector) {
            super(tinyIntVector);
        }

        @Override
        protected boolean isNullAt(ArrayRecord row, int ordinal) {
            return row.isNull(ordinal);
        }

        @Override
        protected byte readByte(ArrayRecord row, int ordinal) {
            return row.getTinyint(ordinal);
        }
    }
}

