/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.utils;

import com.aliyun.odps.table.DataFormat;
import com.aliyun.odps.table.Session;
import com.google.gson.JsonObject;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;

public class SessionUtils {
    public static <T extends Session.Provider> T discoverSessionProvider(ClassLoader classLoader, Class<T> providerClass, String providerIdentifier) throws ClassNotFoundException {
        List<Session.Provider> factories = SessionUtils.discoverProviders(classLoader);
        List foundProviders = factories.stream().filter(f -> providerClass.isAssignableFrom(f.getClass())).collect(Collectors.toList());
        if (foundProviders.isEmpty()) {
            throw new ClassNotFoundException(String.format("Could not find any provider that implement '%s' in the classpath.", providerClass.getName()));
        }
        List matchingProviders = foundProviders.stream().filter(f -> f.identifier().equals(providerIdentifier)).collect(Collectors.toList());
        if (matchingProviders.isEmpty()) {
            throw new ClassNotFoundException(String.format("Could not find any provider for identifier '%s' that implements '%s' in the classpath.\n\nAvailable provider identifiers are:\n\n%s", providerIdentifier, providerClass.getName(), foundProviders.stream().map(Session.Provider::identifier).distinct().sorted().collect(Collectors.joining("\n"))));
        }
        if (matchingProviders.size() > 1) {
            throw new RuntimeException(String.format("Multiple providers for identifier '%s' that implement '%s' found in the classpath.\n\nAmbiguous provider classes are:\n\n%s", providerIdentifier, providerClass.getName(), matchingProviders.stream().map(f -> f.getClass().getName()).sorted().collect(Collectors.joining("\n"))));
        }
        return (T)((Session.Provider)matchingProviders.get(0));
    }

    public static List<Session.Provider> discoverProviders(ClassLoader classLoader) {
        LinkedList<Session.Provider> result = new LinkedList<Session.Provider>();
        ServiceLoader<Session.Provider> serviceLoader = ServiceLoader.load(Session.Provider.class, classLoader);
        for (Session.Provider provider : serviceLoader) {
            result.add(provider);
        }
        return result;
    }

    public static DataFormat parseDataFormat(JsonObject format) {
        DataFormat requiredDataFormat = new DataFormat();
        if (format.has("Type")) {
            requiredDataFormat.setType(DataFormat.Type.byTypeName(format.get("Type").getAsString().toUpperCase()).orElse(DataFormat.Type.UNKNOWN));
        }
        if (format.has("Version")) {
            requiredDataFormat.setVersion(DataFormat.Version.byCode(format.get("Version").getAsString().toUpperCase()).orElse(DataFormat.Version.UNKNOWN));
        }
        return requiredDataFormat;
    }
}

