/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.write.impl.batch;

import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.table.DataFormat;
import com.aliyun.odps.table.DataSchema;
import com.aliyun.odps.table.SessionStatus;
import com.aliyun.odps.table.TableIdentifier;
import com.aliyun.odps.table.configuration.ArrowOptions;
import com.aliyun.odps.table.configuration.DynamicPartitionOptions;
import com.aliyun.odps.table.distribution.Distribution;
import com.aliyun.odps.table.distribution.UnspecifiedDistribution;
import com.aliyun.odps.table.enviroment.EnvironmentSettings;
import com.aliyun.odps.table.order.SortOrder;
import com.aliyun.odps.table.utils.Preconditions;
import com.aliyun.odps.table.write.TableBatchWriteSession;
import com.aliyun.odps.table.write.TableWriteCapabilities;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;

public abstract class TableBatchWriteSessionBase
implements TableBatchWriteSession {
    protected transient EnvironmentSettings settings;
    protected PartitionSpec targetPartitionSpec;
    protected boolean overwrite;
    protected DynamicPartitionOptions dynamicPartitionOptions;
    protected ArrowOptions arrowOptions;
    protected TableWriteCapabilities writeCapabilities;
    protected String sessionId;
    protected TableIdentifier identifier;
    protected SessionStatus sessionStatus;
    protected long expirationTime;
    protected String errorMessage;
    protected DataSchema requiredSchema;
    protected SortOrder[] requiredSortOrders;
    protected Distribution requiredDistribution;
    protected long maxBlockNumber;
    protected Set<DataFormat> supportDataFormats;
    protected long maxFieldSize;

    public TableBatchWriteSessionBase(TableIdentifier identifier, PartitionSpec partitionSpec, boolean overwrite, DynamicPartitionOptions dynamicPartitionOptions, ArrowOptions arrowOptions, TableWriteCapabilities capabilities, EnvironmentSettings settings) throws IOException {
        this(identifier, partitionSpec, overwrite, dynamicPartitionOptions, arrowOptions, capabilities, settings, null);
    }

    public TableBatchWriteSessionBase(TableIdentifier identifier, PartitionSpec partitionSpec, boolean overwrite, DynamicPartitionOptions dynamicPartitionOptions, ArrowOptions arrowOptions, TableWriteCapabilities capabilities, EnvironmentSettings settings, Long maxFieldSize) throws IOException {
        Preconditions.checkNotNull((Object)identifier, (String)"Table identifier", (String)"required");
        Preconditions.checkNotNull((Object)settings, (String)"Environment settings", (String)"required");
        this.settings = settings;
        this.identifier = identifier;
        this.overwrite = overwrite;
        this.sanitize(partitionSpec, dynamicPartitionOptions, arrowOptions, capabilities, maxFieldSize);
        this.initSession();
    }

    public TableBatchWriteSessionBase(TableIdentifier identifier, String sessionId, EnvironmentSettings settings) throws IOException {
        Preconditions.checkNotNull((Object)identifier, (String)"Table identifier", (String)"required");
        Preconditions.checkNotNull((Object)settings, (String)"Environment settings", (String)"required");
        this.sessionId = sessionId;
        this.identifier = identifier;
        this.settings = settings;
        this.reloadSession();
    }

    protected abstract void initSession() throws IOException;

    protected abstract String reloadSession() throws IOException;

    private void sanitize(PartitionSpec partitionSpec, DynamicPartitionOptions dynamicPartitionOptions, ArrowOptions arrowOptions, TableWriteCapabilities writeCapabilities, Long maxFieldSize) {
        this.targetPartitionSpec = partitionSpec == null ? new PartitionSpec() : partitionSpec;
        this.dynamicPartitionOptions = dynamicPartitionOptions == null ? DynamicPartitionOptions.createDefault() : dynamicPartitionOptions;
        this.arrowOptions = arrowOptions == null ? ArrowOptions.createDefault() : arrowOptions;
        this.writeCapabilities = writeCapabilities == null ? TableWriteCapabilities.createDefault() : writeCapabilities;
        this.maxFieldSize = maxFieldSize == null ? 0x800000L : maxFieldSize;
    }

    @Override
    public String getId() {
        if (this.sessionId != null) {
            return this.sessionId;
        }
        throw new IllegalStateException("The table sink has not been initialized yet");
    }

    @Override
    public DataSchema requiredSchema() {
        if (this.requiredSchema != null) {
            return this.requiredSchema;
        }
        throw new IllegalStateException("The table sink has not been initialized yet");
    }

    @Override
    public Optional<Long> maxBlockNumber() {
        return this.maxBlockNumber > 0L ? Optional.of(this.maxBlockNumber) : Optional.empty();
    }

    @Override
    public Distribution requiredDistribution() {
        return this.requiredDistribution != null ? this.requiredDistribution : new UnspecifiedDistribution();
    }

    @Override
    public SortOrder[] requiredOrdering() {
        return this.requiredSortOrders != null ? this.requiredSortOrders : new SortOrder[]{};
    }

    @Override
    public TableIdentifier getTableIdentifier() {
        return this.identifier;
    }

    @Override
    public SessionStatus getStatus() {
        return this.sessionStatus;
    }
}

