/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.configuration;

import com.aliyun.odps.table.DataFormat;
import com.aliyun.odps.table.configuration.CompressionCodec;
import com.aliyun.odps.table.enviroment.EnvironmentSettings;
import com.aliyun.odps.table.utils.ArrowUtils;
import com.aliyun.odps.table.utils.Preconditions;
import org.apache.arrow.memory.BufferAllocator;

public class ReaderOptions {
    private int batchRowCount = 4096;
    private long batchRawSize;
    private BufferAllocator bufferAllocator = ArrowUtils.getDefaultRootAllocator();
    private boolean reuseBatch = true;
    private EnvironmentSettings settings;
    private CompressionCodec compressionCodec = CompressionCodec.NO_COMPRESSION;
    private DataFormat dataFormat = ArrowUtils.getDefaultDataFormat();

    private ReaderOptions() {
    }

    public int getBatchRowCount() {
        return this.batchRowCount;
    }

    public long getBatchRawSize() {
        return this.batchRawSize;
    }

    public BufferAllocator getBufferAllocator() {
        return this.bufferAllocator;
    }

    public boolean isReuseBatch() {
        return this.reuseBatch;
    }

    public EnvironmentSettings getSettings() {
        return this.settings;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public CompressionCodec getCompressionCodec() {
        return this.compressionCodec;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final ReaderOptions readerOptions = new ReaderOptions();

        public Builder withMaxBatchRowCount(int maxBatchRowCount) {
            Preconditions.checkInteger((Integer)maxBatchRowCount, (int)1, (String)"Batch row count");
            this.readerOptions.batchRowCount = maxBatchRowCount;
            return this;
        }

        public Builder withBufferAllocator(BufferAllocator allocator) {
            Preconditions.checkNotNull((Object)allocator, (String)"Buffer allocator");
            this.readerOptions.bufferAllocator = allocator;
            return this;
        }

        public Builder withReuseBatch(boolean reuseBatch) {
            this.readerOptions.reuseBatch = reuseBatch;
            return this;
        }

        public Builder withCompressionCodec(CompressionCodec codec) {
            this.readerOptions.compressionCodec = codec;
            return this;
        }

        public Builder withSettings(EnvironmentSettings settings) {
            this.readerOptions.settings = settings;
            return this;
        }

        public Builder withDataFormat(DataFormat dataFormat) {
            Preconditions.checkNotNull((Object)dataFormat, (String)"Data format");
            this.readerOptions.dataFormat = dataFormat;
            return this;
        }

        public Builder withMaxBatchRawSize(long batchRawSize) {
            this.readerOptions.batchRawSize = batchRawSize;
            return this;
        }

        public ReaderOptions build() {
            Preconditions.checkNotNull((Object)this.readerOptions.settings, (String)"Environment settings", (String)"required");
            return this.readerOptions;
        }
    }
}

