/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.enviroment;

import com.aliyun.odps.Odps;
import com.aliyun.odps.commons.transport.DefaultTransport;
import com.aliyun.odps.commons.transport.Transport;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.table.enviroment.Credentials;
import com.aliyun.odps.table.enviroment.EnvironmentSettings;
import com.aliyun.odps.table.enviroment.LocalEnvironment;
import com.aliyun.odps.table.enviroment.RemoteEnvironment;
import java.net.URI;
import java.net.URISyntaxException;

public abstract class ExecutionEnvironment {
    protected final EnvironmentSettings settings;
    private boolean initialized = false;

    public ExecutionEnvironment(EnvironmentSettings settings) {
        this.settings = settings;
    }

    public static ExecutionEnvironment create(EnvironmentSettings settings) {
        switch (settings.getExecutionMode()) {
            case REMOTE: {
                return new RemoteEnvironment(settings);
            }
            case LOCAL: {
                return new LocalEnvironment(settings);
            }
            case AUTOMATIC: {
                return ExecutionEnvironment.createDefaultEnvironment(settings);
            }
        }
        throw new UnsupportedOperationException();
    }

    protected void ensureInitialized() {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
    }

    protected abstract void initialize();

    public String getServiceEndpoint() {
        return this.settings.getServiceEndpoint().orElseThrow(() -> new IllegalStateException("Get empty service endpoint from execution environment!"));
    }

    public abstract String getTunnelEndpoint(String var1);

    public EnvironmentSettings getSettings() {
        return this.settings;
    }

    public RestClient createHttpClient(String targetProject) {
        this.ensureInitialized();
        Credentials credentials = this.settings.getCredentials();
        RestClient restClient = new RestClient((Transport)new DefaultTransport());
        restClient.setAccount(credentials.getAccount());
        credentials.getAppAccount().ifPresent(arg_0 -> ((RestClient)restClient).setAppAccount(arg_0));
        credentials.getAppStsAccount().ifPresent(arg_0 -> ((RestClient)restClient).setAppStsAccount(arg_0));
        try {
            URI endpoint = new URI(this.getTunnelEndpoint(targetProject));
            restClient.setEndpoint(endpoint.toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Execution environment get tunnel endpoint error:" + e.getMessage());
        }
        this.setRestOptions(restClient);
        return restClient;
    }

    public Odps createOdpsClient() {
        Credentials credentials = this.settings.getCredentials();
        Odps odps = new Odps(credentials.getAccount());
        this.settings.getDefaultProject().ifPresent(arg_0 -> ((Odps)odps).setDefaultProject(arg_0));
        this.settings.getDefaultSchema().ifPresent(arg_0 -> ((Odps)odps).setCurrentSchema(arg_0));
        credentials.getAppAccount().ifPresent(arg_0 -> ((Odps)odps).setAppAccount(arg_0));
        credentials.getAppStsAccount().ifPresent(arg_0 -> ((Odps)odps).setAppStsAccount(arg_0));
        try {
            URI endpoint = new URI(this.getServiceEndpoint());
            odps.setEndpoint(endpoint.toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Execution environment get service endpoint error:" + e.getMessage());
        }
        this.setRestOptions(odps.getRestClient());
        return odps;
    }

    private void setRestOptions(RestClient restClient) {
        restClient.setUserAgent("");
        this.settings.getDefaultProject().ifPresent(arg_0 -> ((RestClient)restClient).setDefaultProject(arg_0));
        this.settings.getDefaultSchema().ifPresent(arg_0 -> ((RestClient)restClient).setCurrentSchema(arg_0));
        this.settings.getRestOptions().ifPresent(restOptions -> {
            restOptions.getConnectTimeout().ifPresent(arg_0 -> ((RestClient)restClient).setConnectTimeout(arg_0));
            restOptions.getReadTimeout().ifPresent(arg_0 -> ((RestClient)restClient).setReadTimeout(arg_0));
            restOptions.getUserAgent().ifPresent(arg_0 -> ((RestClient)restClient).setUserAgent(arg_0));
            restOptions.getRetryTimes().ifPresent(arg_0 -> ((RestClient)restClient).setRetryTimes(arg_0));
            restOptions.isIgnoreCerts().ifPresent(arg_0 -> ((RestClient)restClient).setIgnoreCerts(arg_0));
        });
    }

    private static ExecutionEnvironment createDefaultEnvironment(EnvironmentSettings settings) {
        String mode = System.getenv("MAX_STORAGE_MODE");
        if ("MAX_STORAGE_VSHM_MODE".equals(mode) || "MAX_STORAGE_NET_MODE".equals(mode)) {
            return new LocalEnvironment(settings);
        }
        return new RemoteEnvironment(settings);
    }
}

