/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.optimizer.predicate;

import com.aliyun.odps.data.converter.OdpsRecordConverter;
import com.aliyun.odps.table.optimizer.predicate.Predicate;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.utils.OdpsCommonUtils;
import java.io.Serializable;
import java.util.Objects;

public class Constant
extends Predicate {
    private final Serializable value;
    private final TypeInfo typeInfo;
    private static final OdpsRecordConverter formatter = OdpsRecordConverter.builder().setStrictMode(false).timezone("UTC").enableSqlStandardFormat().build();

    public Constant(Object value) {
        this(value, OdpsCommonUtils.indicateTypeFromClass((Object)value));
    }

    public Constant(Object value, TypeInfo typeInfo) {
        super(Predicate.PredicateType.CONSTANT);
        this.value = (Serializable)value;
        this.typeInfo = typeInfo;
    }

    public static Constant of(Object value) {
        return new Constant(value);
    }

    public static Constant of(Object value, TypeInfo typeInfo) {
        return new Constant(value, typeInfo);
    }

    @Override
    public String toString() {
        try {
            return formatter.formatObject((Object)this.value, this.typeInfo);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid constant value: " + this.value.toString() + "[" + this.value.getClass().getName() + "] for type " + this.typeInfo.getTypeName() + ". You can use RawPredicate to handle constant manually if you think this method does not handle your input appropriately. ", e);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Constant constant = (Constant)o;
        return Objects.equals(this.value, constant.value) && Objects.equals(this.typeInfo, constant.typeInfo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }
}

