/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.optimizer.predicate;

import com.aliyun.odps.table.optimizer.predicate.Predicate;
import java.io.Serializable;

public class UnaryPredicate
extends Predicate {
    private final Operator operator;
    private final Serializable operand;

    public UnaryPredicate(Operator operator, Serializable operand) {
        super(Predicate.PredicateType.UNARY);
        this.operator = operator;
        this.operand = operand;
    }

    public static UnaryPredicate isNull(Serializable operand) {
        return new UnaryPredicate(Operator.IS_NULL, operand);
    }

    public static UnaryPredicate notNull(Serializable operand) {
        return new UnaryPredicate(Operator.NOT_NULL, operand);
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Object getOperand() {
        return this.operand;
    }

    @Override
    public String toString() {
        return this.operand.toString() + " " + this.operator.getDescription();
    }

    public static enum Operator {
        IS_NULL("is null"),
        NOT_NULL("is not null");

        private final String description;

        private Operator(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

