/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.read.impl.batch;

import com.aliyun.odps.Column;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.table.DataSchema;
import com.aliyun.odps.table.configuration.ReaderOptions;
import com.aliyun.odps.table.metrics.Metrics;
import com.aliyun.odps.table.read.SplitReader;
import com.aliyun.odps.table.record.ColumnarBatchRecord;
import java.io.IOException;
import org.apache.arrow.vector.VectorSchemaRoot;

public class SplitRecordReaderImpl
implements SplitReader<ArrayRecord> {
    private final DataSchema readSchema;
    private final ReaderOptions readerOptions;
    private final SplitReader<VectorSchemaRoot> arrowBatchReader;
    private int rowsInBatch = 0;
    private int nextRow = 0;
    private ColumnarBatchRecord batchRecord;

    public SplitRecordReaderImpl(SplitReader<VectorSchemaRoot> arrowReader, DataSchema schema, ReaderOptions options) {
        this.arrowBatchReader = arrowReader;
        this.readSchema = schema;
        this.readerOptions = options;
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.nextRow >= this.rowsInBatch) {
            boolean moreRows = this.arrowBatchReader.hasNext();
            if (moreRows) {
                this.nextRow = 0;
                this.rowsInBatch = this.fillRows();
            }
            return moreRows;
        }
        return true;
    }

    @Override
    public ArrayRecord get() {
        this.batchRecord.setRowId(this.nextRow++);
        return this.batchRecord;
    }

    protected int fillRows() {
        VectorSchemaRoot root = this.arrowBatchReader.get();
        if (this.batchRecord == null || !this.readerOptions.isReuseBatch()) {
            if (this.batchRecord != null) {
                this.batchRecord.close();
            }
            this.batchRecord = new ColumnarBatchRecord(root, this.readSchema.getColumns().toArray(new Column[0]));
        }
        return root.getRowCount();
    }

    @Override
    public void close() throws IOException {
        this.arrowBatchReader.close();
        if (this.batchRecord != null) {
            this.batchRecord.close();
            this.batchRecord = null;
        }
    }

    @Override
    public Metrics currentMetricsValues() {
        return this.arrowBatchReader.currentMetricsValues();
    }
}

