/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.read.split.impl;

import com.aliyun.odps.table.read.split.InputSplitWithRowRange;
import com.aliyun.odps.table.read.split.RowRange;
import com.google.common.base.Preconditions;

public class RowRangeInputSplit
implements InputSplitWithRowRange {
    private static final long serialVersionUID = 1L;
    private final String sessionId;
    private final RowRange rowRange;

    public RowRangeInputSplit(String sessionId, long startIndex, long numRecord) {
        Preconditions.checkArgument((startIndex >= 0L ? 1 : 0) != 0, (Object)"startIndex must be >= 0");
        Preconditions.checkArgument((numRecord >= 0L ? 1 : 0) != 0, (Object)"numRecord must be >= 0");
        this.sessionId = (String)Preconditions.checkNotNull((Object)sessionId);
        this.rowRange = RowRange.of(startIndex, numRecord);
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public RowRange getRowRange() {
        return this.rowRange;
    }

    public int hashCode() {
        return this.rowRange.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RowRangeInputSplit) {
            RowRangeInputSplit other = (RowRangeInputSplit)obj;
            return other.rowRange.equals(this.rowRange) && other.sessionId.equals(this.sessionId);
        }
        return false;
    }

    public String toString() {
        return String.format("RowRangeInputSplit: SessionId=%s RowRange=%s", this.sessionId, this.rowRange.toString());
    }
}

