/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.record.constructor;

import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Struct;
import com.aliyun.odps.table.arrow.constructor.ArrowBigIntWriter;
import java.util.List;
import org.apache.arrow.vector.BigIntVector;

public class ArrowBigIntWriterImpl {

    public static final class StructBigIntWriter
    extends ArrowBigIntWriter<Struct> {
        StructBigIntWriter(BigIntVector bigIntVector) {
            super(bigIntVector);
        }

        @Override
        protected boolean isNullAt(Struct in, int ordinal) {
            return in.getFieldValue(ordinal) == null;
        }

        @Override
        protected long readLong(Struct in, int ordinal) {
            return (Long)in.getFieldValue(ordinal);
        }
    }

    public static final class ListBigIntWriter
    extends ArrowBigIntWriter<List<Object>> {
        ListBigIntWriter(BigIntVector bigIntVector) {
            super(bigIntVector);
        }

        @Override
        protected boolean isNullAt(List<Object> in, int ordinal) {
            return in.get(ordinal) == null;
        }

        @Override
        protected long readLong(List<Object> in, int ordinal) {
            return (Long)in.get(ordinal);
        }
    }

    public static final class RecordBigIntWriter
    extends ArrowBigIntWriter<ArrayRecord> {
        RecordBigIntWriter(BigIntVector bigIntVector) {
            super(bigIntVector);
        }

        @Override
        protected boolean isNullAt(ArrayRecord row, int ordinal) {
            return row.isNull(ordinal);
        }

        @Override
        protected long readLong(ArrayRecord row, int ordinal) {
            return row.getBigint(ordinal);
        }
    }
}

