/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.record.constructor;

import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Struct;
import com.aliyun.odps.table.arrow.constructor.ArrowFloat4Writer;
import java.util.List;
import org.apache.arrow.vector.Float4Vector;

public class ArrowFloat4WriterImpl {

    public static final class StructFloat4Writer
    extends ArrowFloat4Writer<Struct> {
        StructFloat4Writer(Float4Vector float4Vector) {
            super(float4Vector);
        }

        @Override
        protected boolean isNullAt(Struct in, int ordinal) {
            return in.getFieldValue(ordinal) == null;
        }

        @Override
        protected float readFloat(Struct in, int ordinal) {
            return ((Float)in.getFieldValue(ordinal)).floatValue();
        }
    }

    public static final class ListFloat4Writer
    extends ArrowFloat4Writer<List<Object>> {
        ListFloat4Writer(Float4Vector float4Vector) {
            super(float4Vector);
        }

        @Override
        protected boolean isNullAt(List<Object> in, int ordinal) {
            return in.get(ordinal) == null;
        }

        @Override
        protected float readFloat(List<Object> in, int ordinal) {
            return ((Float)in.get(ordinal)).floatValue();
        }
    }

    public static final class RecordFloat4Writer
    extends ArrowFloat4Writer<ArrayRecord> {
        RecordFloat4Writer(Float4Vector float4Vector) {
            super(float4Vector);
        }

        @Override
        protected boolean isNullAt(ArrayRecord row, int ordinal) {
            return row.isNull(ordinal);
        }

        @Override
        protected float readFloat(ArrayRecord row, int ordinal) {
            return row.getFloat(ordinal).floatValue();
        }
    }
}

