/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.record.constructor;

import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Struct;
import com.aliyun.odps.table.arrow.constructor.ArrowIntWriter;
import java.util.List;
import org.apache.arrow.vector.IntVector;

public class ArrowIntWriterImpl {

    public static final class StructIntWriter
    extends ArrowIntWriter<Struct> {
        StructIntWriter(IntVector intVector) {
            super(intVector);
        }

        @Override
        protected boolean isNullAt(Struct in, int ordinal) {
            return in.getFieldValue(ordinal) == null;
        }

        @Override
        protected int readInt(Struct in, int ordinal) {
            return (Integer)in.getFieldValue(ordinal);
        }
    }

    public static final class ListIntWriter
    extends ArrowIntWriter<List<Object>> {
        ListIntWriter(IntVector intVector) {
            super(intVector);
        }

        @Override
        protected boolean isNullAt(List<Object> in, int ordinal) {
            return in.get(ordinal) == null;
        }

        @Override
        protected int readInt(List<Object> in, int ordinal) {
            return (Integer)in.get(ordinal);
        }
    }

    public static final class RecordIntWriter
    extends ArrowIntWriter<ArrayRecord> {
        RecordIntWriter(IntVector intVector) {
            super(intVector);
        }

        @Override
        protected boolean isNullAt(ArrayRecord row, int ordinal) {
            return row.isNull(ordinal);
        }

        @Override
        protected int readInt(ArrayRecord row, int ordinal) {
            return row.getInt(ordinal);
        }
    }
}

