/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.tools;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Instances;
import com.aliyun.odps.Odps;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.account.AliyunAccount;
import com.aliyun.odps.request.cupid.CupidRequestProxy;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class GenAppURL {
    private Map<String, String> confs;

    public GenAppURL(String confPath) throws IOException {
        File file = new File(confPath);
        if (!file.exists()) {
            throw new IOException("Conf file does not exist");
        }
        try (InputStreamReader inReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");){
            this.confs = new HashMap<String, String>();
            Properties properties = new Properties();
            properties.load(inReader);
            for (String key : properties.stringPropertyNames()) {
                String value = properties.getProperty(key).trim();
                this.confs.put(key.trim(), value);
            }
        }
        catch (IOException e) {
            throw new IOException("Failed when loading Spark properties from $filename", e);
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.err.println("Please add the args: confpath [instanceid]");
            System.exit(0);
        }
        String confPath = args[0];
        String instanceId = args.length > 1 ? args[1] : null;
        GenAppURL tools = new GenAppURL(confPath);
        if (instanceId == null) {
            Map<String, String> kv = tools.getRunningInstances();
            for (Map.Entry<String, String> entry : kv.entrySet()) {
                if (null == entry.getValue()) continue;
                System.out.println(entry.getKey() + "\n" + entry.getValue());
            }
        } else {
            System.out.println(instanceId + "\n" + tools.getJobViewUrl(instanceId.trim()));
        }
    }

    public Odps getOdps() {
        AliyunAccount account = new AliyunAccount(this.confs.get("access_id"), this.confs.get("access_key"));
        Odps odps = new Odps((Account)account);
        odps.setEndpoint(this.confs.get("end_point"));
        odps.setDefaultProject(this.confs.get("project_name"));
        return odps;
    }

    private Map<String, String> getRunningInstances() {
        Instances instances = this.getOdps().instances();
        if (instances == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        while (instances.iterator().hasNext()) {
            Instance instance = (Instance)instances.iterator().next();
            if (instance.getStatus() != Instance.Status.RUNNING) continue;
            try {
                String jobViewUrl = this.getJobViewUrl(instance.getId());
                map.put(instance.getId(), jobViewUrl);
            }
            catch (IOException e) {
                System.err.println("Fail to get jobview url for " + instance.getId());
            }
        }
        return map;
    }

    public String getJobViewUrl(String instanceId) throws IOException {
        return CupidRequestProxy.getInstance().cupidRequestRPC(instanceId, this.getOdps(), instanceId, "requestappurlfrommeta");
    }
}

