/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.iot.api.auth.handler;

import com.aliyun.openservices.iot.api.auth.AuthHandler;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;

public class AppKeyAuthHandler
implements AuthHandler {
    private static final String PARAM_RANDOM = "param-random";
    private static final String SHA_256 = "SHA256";
    private static final String PARAM_SIGN_METHOD = "param-sign-method";
    private static final String PARAM_SIGN = "param-sign";
    private Map<String, String> params = Maps.newHashMap();

    public AppKeyAuthHandler(Map<String, String> authParams) {
        this.params.putAll(authParams);
        String appSecret = this.params.get("appSecret");
        String random = String.valueOf(new Random().nextLong());
        String signContent = "random=" + random;
        String sign = new HmacUtils(HmacAlgorithms.HMAC_SHA_256, appSecret).hmacHex(signContent);
        this.params.put("name", "appkey");
        this.params.put(PARAM_SIGN, sign);
        this.params.put(PARAM_RANDOM, random);
        this.params.put(PARAM_SIGN_METHOD, SHA_256);
        this.params.remove("appSecret");
    }

    @Override
    public Map<String, String> getAuthParams() {
        return this.params;
    }
}

