/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.iot.api.http2.callback;

import com.aliyun.openservices.iot.api.http2.callback.Http2StreamListener;
import com.aliyun.openservices.iot.api.http2.connection.Connection;
import com.aliyun.openservices.iot.api.http2.entity.StreamData;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttp2StreamDataReceiver
implements Http2StreamListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractHttp2StreamDataReceiver.class);
    private static final String DATA_CACHE_KEY = "data_cache_key";

    @Override
    public void onDataRead(Connection connection, Http2Stream stream, byte[] data, boolean endOfStream) {
        log.debug("receive data on connection {}, streamId {}", (Object)connection, (Object)stream.id());
        StreamData streamData = this.getStreamData(connection, stream);
        if (streamData == null) {
            this.onStreamError(connection, stream, new IOException(connection.toString() + " received data frame on " + stream.id() + ", but headers hasn't received"));
            return;
        }
        streamData.addData(data);
        if (endOfStream) {
            this.onDataRead(connection, stream, streamData);
            stream.closeLocalSide();
        }
    }

    @Override
    public void onHeadersRead(Connection connection, Http2Stream stream, Http2Headers headers, boolean endOfStream) {
        Http2Connection.PropertyKey key = connection.getPropertyKey(DATA_CACHE_KEY);
        StreamData streamData = this.getStreamData(connection, stream);
        if (streamData == null) {
            streamData = new StreamData();
            stream.setProperty(key, (Object)streamData);
        }
        streamData.addHeaders(headers);
        if (endOfStream) {
            this.onDataRead(connection, stream, streamData);
            stream.closeLocalSide();
        }
    }

    protected StreamData getStreamData(Connection connection, Http2Stream stream) {
        return (StreamData)stream.getProperty(connection.getPropertyKey(DATA_CACHE_KEY));
    }

    public abstract void onDataRead(Connection var1, Http2Stream var2, StreamData var3);
}

