/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.loghub.client;

import com.aliyun.openservices.log.exception.LogException;
import com.aliyun.openservices.loghub.client.ILogHubCheckPointTracker;
import com.aliyun.openservices.loghub.client.LogHubClientAdapter;
import com.aliyun.openservices.loghub.client.LogHubHeartBeat;
import com.aliyun.openservices.loghub.client.LoghubClientUtil;
import com.aliyun.openservices.loghub.client.config.LogHubConfig;
import com.aliyun.openservices.loghub.client.exceptions.LogHubCheckPointException;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLogHubCheckPointTracker
implements ILogHubCheckPointTracker {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLogHubCheckPointTracker.class);
    private final LogHubClientAdapter loghubClient;
    private String nextCursor;
    private String latestCursor;
    private String pendingCheckpoint = "";
    private String lastSavedCheckpoint = "";
    private final String consumer;
    private final int shardID;
    private final long autoCommitInterval;
    private final boolean autoCommitEnabled;
    private volatile boolean allCommitted;
    private long lastCheckTimeInMillis;
    private final LogHubHeartBeat heartBeat;
    private String currentCursor;

    public DefaultLogHubCheckPointTracker(LogHubClientAdapter loghubClient, LogHubConfig config, LogHubHeartBeat heartBeat, int shardId) {
        this.loghubClient = loghubClient;
        this.consumer = config.getConsumer();
        this.shardID = shardId;
        this.lastCheckTimeInMillis = System.currentTimeMillis();
        this.autoCommitEnabled = config.isAutoCommitEnabled();
        this.autoCommitInterval = config.getAutoCommitIntervalMs();
        this.allCommitted = true;
        this.heartBeat = heartBeat;
    }

    public void setNextCursor(String nextCursor) {
        this.nextCursor = nextCursor;
        if (nextCursor == null && this.latestCursor != null || nextCursor != null && !nextCursor.equals(this.latestCursor)) {
            this.latestCursor = nextCursor;
            this.allCommitted = false;
        }
    }

    public String getNextCursor() {
        return this.nextCursor;
    }

    @Override
    public void saveCheckPoint(boolean persistent) throws LogHubCheckPointException {
        this.pendingCheckpoint = this.nextCursor;
        if (persistent) {
            this.flushCheckpoint();
        }
    }

    public void setInPersistentCheckPoint(String cursor) {
        this.lastSavedCheckpoint = cursor;
    }

    public void saveCheckPoint(String cursor, boolean persistent) throws LogHubCheckPointException {
        this.pendingCheckpoint = cursor;
        if (persistent) {
            this.flushCheckpoint();
        }
    }

    public void flushCheckpoint() throws LogHubCheckPointException {
        String checkpoint = this.pendingCheckpoint;
        if (checkpoint == null || checkpoint.isEmpty() || checkpoint.equals(this.lastSavedCheckpoint)) {
            return;
        }
        int i = 0;
        while (true) {
            try {
                this.loghubClient.UpdateCheckPoint(this.shardID, this.consumer, checkpoint);
                this.lastSavedCheckpoint = checkpoint;
            }
            catch (LogException e) {
                String errorCode = e.GetErrorCode();
                if ("ConsumerNotExist".equalsIgnoreCase(errorCode) || "ConsumerNotMatch".equalsIgnoreCase(errorCode)) {
                    this.heartBeat.markIdle(this.shardID);
                    LOG.warn("Consumer {} has been removed or shard has been reassigned - {}", (Object)this.consumer, (Object)e.GetErrorMessage());
                    break;
                }
                if ("ShardNotExist".equalsIgnoreCase(errorCode)) {
                    this.heartBeat.markIdle(this.shardID);
                    LOG.warn("Shard {} doest not exist any more", (Object)this.shardID);
                    break;
                }
                if (i >= 2) {
                    throw new LogHubCheckPointException("Failed to save checkpoint, " + this.consumer + ", " + this.shardID + ", " + checkpoint, e);
                }
                LoghubClientUtil.sleep(new Random().nextInt(200));
                ++i;
                continue;
            }
            break;
        }
        if (this.latestCursor == null || this.latestCursor.equals(this.lastSavedCheckpoint)) {
            this.allCommitted = true;
        }
    }

    void flushCheckpointIfNeeded() {
        if (!this.autoCommitEnabled) {
            return;
        }
        long curTime = System.currentTimeMillis();
        if (curTime > this.lastCheckTimeInMillis + this.autoCommitInterval) {
            try {
                this.flushCheckpoint();
            }
            catch (LogHubCheckPointException e) {
                LOG.error("Error while flushing checkpoint", (Throwable)e);
            }
            this.lastCheckTimeInMillis = curTime;
        }
    }

    @Override
    public String getCheckPoint() {
        return this.pendingCheckpoint;
    }

    public void setCurrentCursor(String currentCursor) {
        this.currentCursor = currentCursor;
    }

    @Override
    public String getCurrentCursor() {
        return this.currentCursor;
    }

    boolean isAllCommitted() {
        return this.allCommitted;
    }
}

