/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.loghub.client;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LoghubClientUtil {
    private static final Logger LOG = LoggerFactory.getLogger(LoghubClientUtil.class);

    LoghubClientUtil() {
    }

    static void shutdownThreadPool(ExecutorService pool, long timeout) {
        if (pool == null) {
            return;
        }
        pool.shutdown();
        try {
            if (!pool.awaitTermination(timeout, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(timeout, TimeUnit.SECONDS)) {
                    LOG.warn("Stopping executor pool failed");
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    static void sleep(long timeToSleepMillis) {
        try {
            Thread.sleep(timeToSleepMillis);
        }
        catch (InterruptedException e) {
            LOG.debug("Interrupted while sleeping");
            Thread.currentThread().interrupt();
        }
    }
}

