/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.impl.rocketmq;

import com.alibaba.rocketmq.client.exception.MQBrokerException;
import com.alibaba.rocketmq.client.exception.MQClientException;
import com.alibaba.rocketmq.client.log.ClientLogger;
import com.alibaba.rocketmq.client.producer.DefaultMQProducer;
import com.alibaba.rocketmq.common.UtilAll;
import com.alibaba.rocketmq.remoting.RPCHook;
import com.alibaba.rocketmq.remoting.exception.RemotingConnectException;
import com.alibaba.rocketmq.remoting.exception.RemotingTimeoutException;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.aliyun.openservices.ons.api.impl.rocketmq.ClientRPCHook;
import com.aliyun.openservices.ons.api.impl.rocketmq.FAQ;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSClientAbstract;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSUtil;
import java.util.Properties;
import org.slf4j.Logger;

public class ProducerImpl
extends ONSClientAbstract
implements Producer {
    private static final Logger log = ClientLogger.getLog();
    private final DefaultMQProducer defaultMQProducer;

    public ProducerImpl(Properties properties) {
        super(properties);
        this.defaultMQProducer = new DefaultMQProducer((RPCHook)new ClientRPCHook(this.sessionCredentials));
        String producerGroup = properties.getProperty("ProducerId", "__ONS_PRODUCER_DEFAULT_GROUP");
        this.defaultMQProducer.setProducerGroup(producerGroup);
        String sendMsgTimeoutMillis = properties.getProperty("SendMsgTimeoutMillis", "5000");
        this.defaultMQProducer.setSendMsgTimeout(Integer.parseInt(sendMsgTimeoutMillis));
        this.defaultMQProducer.setInstanceName(this.buildIntanceName());
        this.defaultMQProducer.setNamesrvAddr(this.getNameServerAddr());
        this.defaultMQProducer.setMaxMessageSize(131072);
    }

    public void start() {
        try {
            this.defaultMQProducer.start();
        }
        catch (Exception e) {
            throw new ONSClientException(e.getMessage(), (Throwable)e);
        }
    }

    public void shutdown() {
        this.defaultMQProducer.shutdown();
    }

    private void checkONSServiceState() {
        switch (this.defaultMQProducer.getDefaultMQProducerImpl().getServiceState()) {
            case CREATE_JUST: {
                throw new ONSClientException(FAQ.errorMessage(String.format("You do not have start the producer[" + UtilAll.getPid() + "], %s", this.defaultMQProducer.getDefaultMQProducerImpl().getServiceState()), "https://github.com/alibaba/ons/issues/4"));
            }
            case SHUTDOWN_ALREADY: {
                throw new ONSClientException(FAQ.errorMessage(String.format("Your producer has been shut down, %s", this.defaultMQProducer.getDefaultMQProducerImpl().getServiceState()), "https://github.com/alibaba/ons/issues/4"));
            }
            case START_FAILED: {
                throw new ONSClientException(FAQ.errorMessage(String.format("When you start your service throws an exception, %s", this.defaultMQProducer.getDefaultMQProducerImpl().getServiceState()), "https://github.com/alibaba/ons/issues/4"));
            }
            case RUNNING: {
                break;
            }
        }
    }

    private void checkProducerException(Exception e, Message message) {
        if (e instanceof MQClientException) {
            if (e.getCause() != null) {
                if (e.getCause() instanceof RemotingConnectException) {
                    throw new ONSClientException(FAQ.errorMessage(String.format("Connect broker failed, Topic: %s", message.getTopic()), "https://github.com/alibaba/ons/issues/2"));
                }
                if (e.getCause() instanceof RemotingTimeoutException) {
                    throw new ONSClientException(FAQ.errorMessage(String.format("Send message to broker timeout, %dms, Topic: %s", this.defaultMQProducer.getSendMsgTimeout(), message.getTopic()), "https://github.com/alibaba/ons/issues/3"));
                }
                if (e.getCause() instanceof MQBrokerException) {
                    MQBrokerException excep = (MQBrokerException)e.getCause();
                    throw new ONSClientException(FAQ.errorMessage(String.format("Receive a broker exception, Topic: %s, %s", message.getTopic(), excep.getErrorMessage()), "https://github.com/alibaba/ons/issues/5"));
                }
            } else {
                MQClientException excep = (MQClientException)((Object)e);
                if (-1 == excep.getResponseCode()) {
                    throw new ONSClientException(FAQ.errorMessage(String.format("Topic does not exist, Topic: %s, %s", message.getTopic(), excep.getErrorMessage()), "https://github.com/alibaba/ons/issues/7"));
                }
                if (13 == excep.getResponseCode()) {
                    throw new ONSClientException(FAQ.errorMessage(String.format("ONS Client check message exception, Topic: %s, %s", message.getTopic(), excep.getErrorMessage()), "https://github.com/alibaba/ons/issues/6"));
                }
            }
        }
        throw new ONSClientException("defaultMQProducer send exception", (Throwable)e);
    }

    public SendResult send(Message message) {
        this.checkONSServiceState();
        com.alibaba.rocketmq.common.message.Message msgRMQ = ONSUtil.msgConvert(message);
        try {
            com.alibaba.rocketmq.client.producer.SendResult sendResultRMQ = this.defaultMQProducer.send(msgRMQ);
            SendResult sendResult = new SendResult();
            sendResult.setMessageId(sendResultRMQ.getMsgId());
            return sendResult;
        }
        catch (Exception e) {
            log.error(String.format("Send message Exception, %s", message), (Throwable)e);
            this.checkProducerException(e, message);
            return null;
        }
    }

    public void sendOneway(Message message) {
        this.checkONSServiceState();
        com.alibaba.rocketmq.common.message.Message msgRMQ = ONSUtil.msgConvert(message);
        try {
            this.defaultMQProducer.sendOneway(msgRMQ);
        }
        catch (Exception e) {
            log.error(String.format("Send message oneway Exception, %s", message), (Throwable)e);
            this.checkProducerException(e, message);
        }
    }
}

