/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.NamespaceUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.RemotingUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.TlsSystemConfig;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.LanguageCode;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import java.util.HashSet;
import java.util.Set;

public class ClientConfig {
    public static final String SEND_MESSAGE_WITH_VIP_CHANNEL_PROPERTY = "com.rocketmq.sendMessageWithVIPChannel";
    public static final String DECODE_READ_BODY = "com.rocketmq.read.body";
    public static final String DECODE_DECOMPRESS_BODY = "com.rocketmq.decompress.body";
    public static final String AUTO_CLEAN_NO_ROUTE_TOPIC = "com.rocketmq.autoclean.noroute.topic";
    public static final String CLIENT_CALLBACK_EXECUTOR_THREAD_NUMS = "client.callback.executor.thread.nums";
    private String namesrvAddr = System.getProperty("rocketmq.namesrv.addr", System.getenv("NAMESRV_ADDR"));
    private String clientIP = RemotingUtil.getLocalAddress();
    private String instanceName = System.getProperty("rocketmq.client.name", "DEFAULT");
    protected String namespace;
    private int clientCallbackExecutorThreads = Integer.parseInt(System.getProperty("client.callback.executor.thread.nums", String.valueOf(Runtime.getRuntime().availableProcessors())));
    private int pollNameServerInterval = 30000;
    private int heartbeatBrokerInterval = 30000;
    private int persistConsumerOffsetInterval = 5000;
    private boolean unitMode = false;
    private String unitName;
    private boolean vipChannelEnabled = Boolean.parseBoolean(System.getProperty("com.rocketmq.sendMessageWithVIPChannel", "true"));
    private boolean decodeReadBody = Boolean.parseBoolean(System.getProperty("com.rocketmq.read.body", "true"));
    private boolean decodeDecompressBody = Boolean.parseBoolean(System.getProperty("com.rocketmq.decompress.body", "true"));
    private boolean autoCleanTopicRouteNotFound = Boolean.parseBoolean(System.getProperty("com.rocketmq.autoclean.noroute.topic", "false"));
    private boolean recordApiStats = false;
    private boolean disableCallbackExecutor = false;
    private boolean disableNettyWorkerGroup = false;
    private boolean useTLS = TlsSystemConfig.tlsEnable;
    private LanguageCode language = LanguageCode.JAVA;

    public String buildMQClientId() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClientIP());
        sb.append("@");
        sb.append(this.getInstanceName());
        if (!UtilAll.isBlank(this.unitName)) {
            sb.append("@");
            sb.append(this.unitName);
        }
        return sb.toString();
    }

    public String getClientIP() {
        return this.clientIP;
    }

    public void setClientIP(String clientIP) {
        this.clientIP = clientIP;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public void changeInstanceNameToPID() {
        if (this.instanceName.equals("DEFAULT")) {
            this.instanceName = String.valueOf(UtilAll.getPid());
        }
    }

    public String withNamespace(String resource) {
        return NamespaceUtil.wrapNamespace(this.getNamespace(), resource);
    }

    public Set<String> withNamespace(Set<String> resourceSet) {
        HashSet<String> resourceWithNamespace = new HashSet<String>();
        for (String resource : resourceSet) {
            resourceWithNamespace.add(this.withNamespace(resource));
        }
        return resourceWithNamespace;
    }

    public String withoutNamespace(String resource) {
        return NamespaceUtil.withoutNamespace(resource, this.getNamespace());
    }

    public Set<String> withoutNamespace(Set<String> resourceSet) {
        HashSet<String> resourceWithoutNamespace = new HashSet<String>();
        for (String resource : resourceSet) {
            resourceWithoutNamespace.add(this.withoutNamespace(resource));
        }
        return resourceWithoutNamespace;
    }

    public MessageQueue queueWithNamespace(MessageQueue queue) {
        if (StringUtils.isEmpty(this.getNamespace())) {
            return queue;
        }
        return new MessageQueue(this.withNamespace(queue.getTopic()), queue.getBrokerName(), queue.getQueueId());
    }

    public void resetClientConfig(ClientConfig cc) {
        this.namesrvAddr = cc.namesrvAddr;
        this.clientIP = cc.clientIP;
        this.instanceName = cc.instanceName;
        this.clientCallbackExecutorThreads = cc.clientCallbackExecutorThreads;
        this.pollNameServerInterval = cc.pollNameServerInterval;
        this.heartbeatBrokerInterval = cc.heartbeatBrokerInterval;
        this.persistConsumerOffsetInterval = cc.persistConsumerOffsetInterval;
        this.unitMode = cc.unitMode;
        this.unitName = cc.unitName;
        this.vipChannelEnabled = cc.vipChannelEnabled;
        this.decodeReadBody = cc.decodeReadBody;
        this.decodeDecompressBody = cc.decodeDecompressBody;
        this.useTLS = cc.useTLS;
        this.language = cc.language;
        this.namespace = cc.namespace;
        this.autoCleanTopicRouteNotFound = cc.autoCleanTopicRouteNotFound;
        this.recordApiStats = cc.recordApiStats;
        this.disableCallbackExecutor = cc.disableCallbackExecutor;
        this.disableNettyWorkerGroup = cc.disableNettyWorkerGroup;
    }

    public ClientConfig cloneClientConfig() {
        ClientConfig cc = new ClientConfig();
        cc.namesrvAddr = this.namesrvAddr;
        cc.clientIP = this.clientIP;
        cc.instanceName = this.instanceName;
        cc.clientCallbackExecutorThreads = this.clientCallbackExecutorThreads;
        cc.pollNameServerInterval = this.pollNameServerInterval;
        cc.heartbeatBrokerInterval = this.heartbeatBrokerInterval;
        cc.persistConsumerOffsetInterval = this.persistConsumerOffsetInterval;
        cc.unitMode = this.unitMode;
        cc.unitName = this.unitName;
        cc.vipChannelEnabled = this.vipChannelEnabled;
        cc.decodeReadBody = this.decodeReadBody;
        cc.decodeDecompressBody = this.decodeDecompressBody;
        cc.useTLS = this.useTLS;
        cc.language = this.language;
        cc.namespace = this.namespace;
        cc.autoCleanTopicRouteNotFound = this.autoCleanTopicRouteNotFound;
        cc.recordApiStats = this.recordApiStats;
        cc.disableNettyWorkerGroup = this.disableNettyWorkerGroup;
        cc.disableCallbackExecutor = this.disableCallbackExecutor;
        return cc;
    }

    public String getNamesrvAddr() {
        return this.namesrvAddr;
    }

    public void setNamesrvAddr(String namesrvAddr) {
        this.namesrvAddr = namesrvAddr;
    }

    public int getClientCallbackExecutorThreads() {
        return this.clientCallbackExecutorThreads;
    }

    public void setClientCallbackExecutorThreads(int clientCallbackExecutorThreads) {
        this.clientCallbackExecutorThreads = clientCallbackExecutorThreads;
    }

    public int getPollNameServerInterval() {
        return this.pollNameServerInterval;
    }

    public void setPollNameServerInterval(int pollNameServerInterval) {
        this.pollNameServerInterval = pollNameServerInterval;
    }

    public int getHeartbeatBrokerInterval() {
        return this.heartbeatBrokerInterval;
    }

    public void setHeartbeatBrokerInterval(int heartbeatBrokerInterval) {
        this.heartbeatBrokerInterval = heartbeatBrokerInterval;
    }

    public int getPersistConsumerOffsetInterval() {
        return this.persistConsumerOffsetInterval;
    }

    public void setPersistConsumerOffsetInterval(int persistConsumerOffsetInterval) {
        this.persistConsumerOffsetInterval = persistConsumerOffsetInterval;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public boolean isUnitMode() {
        return this.unitMode;
    }

    public void setUnitMode(boolean unitMode) {
        this.unitMode = unitMode;
    }

    public boolean isVipChannelEnabled() {
        return this.vipChannelEnabled;
    }

    public void setVipChannelEnabled(boolean vipChannelEnabled) {
        this.vipChannelEnabled = vipChannelEnabled;
    }

    public boolean isDecodeReadBody() {
        return this.decodeReadBody;
    }

    public void setDecodeReadBody(boolean decodeReadBody) {
        this.decodeReadBody = decodeReadBody;
    }

    public boolean isDecodeDecompressBody() {
        return this.decodeDecompressBody;
    }

    public void setDecodeDecompressBody(boolean decodeDecompressBody) {
        this.decodeDecompressBody = decodeDecompressBody;
    }

    public String getNamespace() {
        return this.namespace;
    }

    protected void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public boolean isUseTLS() {
        return this.useTLS;
    }

    public void setUseTLS(boolean useTLS) {
        this.useTLS = useTLS;
    }

    public LanguageCode getLanguage() {
        return this.language;
    }

    public void setLanguage(LanguageCode language) {
        this.language = language;
    }

    public boolean isAutoCleanTopicRouteNotFound() {
        return this.autoCleanTopicRouteNotFound;
    }

    public void setAutoCleanTopicRouteNotFound(boolean autoCleanTopicRouteNotFound) {
        this.autoCleanTopicRouteNotFound = autoCleanTopicRouteNotFound;
    }

    public boolean isRecordApiStats() {
        return this.recordApiStats;
    }

    public void setRecordApiStats(boolean recordApiStats) {
        this.recordApiStats = recordApiStats;
    }

    public boolean isDisableCallbackExecutor() {
        return this.disableCallbackExecutor;
    }

    public void setDisableCallbackExecutor(boolean disableCallbackExecutor) {
        this.disableCallbackExecutor = disableCallbackExecutor;
    }

    public boolean isDisableNettyWorkerGroup() {
        return this.disableNettyWorkerGroup;
    }

    public void setDisableNettyWorkerGroup(boolean disableNettyWorkerGroup) {
        this.disableNettyWorkerGroup = disableNettyWorkerGroup;
    }

    public String toString() {
        return "ClientConfig [namesrvAddr=" + this.namesrvAddr + ", clientIP=" + this.clientIP + ", instanceName=" + this.instanceName + ", clientCallbackExecutorThreads=" + this.clientCallbackExecutorThreads + ", pollNameServerInterval=" + this.pollNameServerInterval + ", heartbeatBrokerInterval=" + this.heartbeatBrokerInterval + ", persistConsumerOffsetInterval=" + this.persistConsumerOffsetInterval + ", unitMode=" + this.unitMode + ", unitName=" + this.unitName + ", vipChannelEnabled=" + this.vipChannelEnabled + ", decodeReadBody=" + this.decodeReadBody + ", decodeDecompressBody=" + this.decodeDecompressBody + ", useTLS=" + this.useTLS + ", language=" + this.language.name() + ", namespace=" + this.namespace + ", autoCleanNoRouteTopic=" + this.autoCleanTopicRouteNotFound + "]";
    }
}

