/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.impl.tracehook;

import com.alibaba.ons.open.trace.core.common.OnsTraceBean;
import com.alibaba.ons.open.trace.core.common.OnsTraceContext;
import com.alibaba.ons.open.trace.core.common.OnsTraceType;
import com.alibaba.ons.open.trace.core.dispatch.AsyncDispatcher;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.listener.ConsumeExactlyOnceStatus;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.listener.ConsumeReturnType;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.hook.ConsumeMessageContext;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.hook.ConsumeMessageHook;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageExt;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.NamespaceUtil;
import java.util.ArrayList;

public class OnsConsumeMessageHookImpl
implements ConsumeMessageHook {
    private AsyncDispatcher localDispatcher;

    public OnsConsumeMessageHookImpl(AsyncDispatcher localDispatcher) {
        this.localDispatcher = localDispatcher;
    }

    @Override
    public String hookName() {
        return "OnsConsumeMessageHook";
    }

    @Override
    public void consumeMessageBefore(ConsumeMessageContext context) {
        if (context == null || context.getMsgList() == null || context.getMsgList().isEmpty()) {
            return;
        }
        OnsTraceContext onsTraceContext = new OnsTraceContext();
        context.setMqTraceContext(onsTraceContext);
        onsTraceContext.setTraceType(OnsTraceType.SubBefore);
        String userGroup = NamespaceUtil.withoutNamespace(context.getConsumerGroup(), context.getNamespace());
        onsTraceContext.setGroupName(userGroup);
        ArrayList<OnsTraceBean> beans = new ArrayList<OnsTraceBean>();
        for (MessageExt msg : context.getMsgList()) {
            if (msg == null) continue;
            String regionId = msg.getProperty("MSG_REGION");
            String traceOn = msg.getProperty("TRACE_ON");
            if (regionId == null || regionId.equals("DefaultRegion") || traceOn != null && "false".equals(traceOn)) continue;
            OnsTraceBean traceBean = new OnsTraceBean();
            String userTopic = NamespaceUtil.withoutNamespace(msg.getTopic(), context.getNamespace());
            traceBean.setTopic(userTopic);
            traceBean.setMsgId(msg.getMsgId());
            traceBean.setTags(msg.getTags());
            traceBean.setKeys(msg.getKeys());
            traceBean.setStoreTime(msg.getStoreTimestamp());
            traceBean.setBodyLength(msg.getStoreSize());
            traceBean.setRetryTimes(msg.getReconsumeTimes());
            onsTraceContext.setRegionId(regionId);
            beans.add(traceBean);
        }
        if (beans.size() > 0) {
            onsTraceContext.setTraceBeans(beans);
            onsTraceContext.setTimeStamp(System.currentTimeMillis());
            this.localDispatcher.append(onsTraceContext);
        }
    }

    @Override
    public void consumeMessageAfter(ConsumeMessageContext context) {
        String exactlyOnceStatus;
        if (context == null || context.getMsgList() == null || context.getMsgList().isEmpty()) {
            return;
        }
        OnsTraceContext subBeforeContext = (OnsTraceContext)context.getMqTraceContext();
        if (subBeforeContext.getRegionId().equals("DefaultRegion")) {
            return;
        }
        if (subBeforeContext.getTraceBeans() == null || subBeforeContext.getTraceBeans().size() < 1) {
            return;
        }
        OnsTraceContext subAfterContext = new OnsTraceContext();
        subAfterContext.setTraceType(OnsTraceType.SubAfter);
        subAfterContext.setRegionId(subBeforeContext.getRegionId());
        subAfterContext.setGroupName(subBeforeContext.getGroupName());
        subAfterContext.setRequestId(subBeforeContext.getRequestId());
        subAfterContext.setSuccess(context.isSuccess());
        int costTime = (int)((System.currentTimeMillis() - subBeforeContext.getTimeStamp()) / (long)context.getMsgList().size());
        subAfterContext.setCostTime(costTime);
        subAfterContext.setTraceBeans(subBeforeContext.getTraceBeans());
        String contextType = context.getProps().get("ConsumeContextType");
        if (contextType != null) {
            subAfterContext.setContextCode(ConsumeReturnType.valueOf(contextType).ordinal());
        }
        if ((exactlyOnceStatus = context.getProps().get("ConsumeExactlyOnceStatus")) != null) {
            subAfterContext.setExactlyOnceStatus(ConsumeExactlyOnceStatus.valueOf(exactlyOnceStatus).ordinal());
        }
        this.localDispatcher.append(subAfterContext);
    }
}

