/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/log.proto

package com.aliyun.openservices.ons.shaded.com.google.api;

/**
 *
 *
 * <pre>
 * A description of a log type. Example in YAML format:
 *     - name: library.googleapis.com/activity_history
 *       description: The history of borrowing and returning library items.
 *       display_name: Activity
 *       labels:
 *       - key: /customer_id
 *         description: Identifier of a library customer
 * </pre>
 *
 * Protobuf type {@code google.api.LogDescriptor}
 */
public final class LogDescriptor extends com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.LogDescriptor)
    LogDescriptorOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use LogDescriptor.newBuilder() to construct.
  private LogDescriptor(com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LogDescriptor() {
    name_ = "";
    labels_ = java.util.Collections.emptyList();
    description_ = "";
    displayName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LogDescriptor();
  }

  @java.lang.Override
  public final com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private LogDescriptor(
      com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                labels_ = new java.util.ArrayList<com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor>();
                mutable_bitField0_ |= 0x00000001;
              }
              labels_.add(
                  input.readMessage(com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor.parser(), extensionRegistry));
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              description_ = s;
              break;
            }
          case 34:
            {
              java.lang.String s = input.readStringRequireUtf8();

              displayName_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        labels_ = java.util.Collections.unmodifiableList(labels_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.aliyun.openservices.ons.shaded.com.google.api.LogProto.internal_static_google_api_LogDescriptor_descriptor;
  }

  @java.lang.Override
  protected com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.aliyun.openservices.ons.shaded.com.google.api.LogProto.internal_static_google_api_LogDescriptor_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor.class, com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * The name of the log. It must be less than 512 characters long and can
   * include the following characters: upper- and lower-case alphanumeric
   * characters [A-Za-z0-9], and punctuation characters including
   * slash, underscore, hyphen, period [/_-.].
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString bs = (com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the log. It must be less than 512 characters long and can
   * include the following characters: upper- and lower-case alphanumeric
   * characters [A-Za-z0-9], and punctuation characters including
   * slash, underscore, hyphen, period [/_-.].
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString b =
          com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 2;
  private java.util.List<com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor> labels_;
  /**
   *
   *
   * <pre>
   * The set of labels that are available to describe a specific log entry.
   * Runtime requests that contain labels not specified here are
   * considered invalid.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor> getLabelsList() {
    return labels_;
  }
  /**
   *
   *
   * <pre>
   * The set of labels that are available to describe a specific log entry.
   * Runtime requests that contain labels not specified here are
   * considered invalid.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptorOrBuilder>
      getLabelsOrBuilderList() {
    return labels_;
  }
  /**
   *
   *
   * <pre>
   * The set of labels that are available to describe a specific log entry.
   * Runtime requests that contain labels not specified here are
   * considered invalid.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
   */
  @java.lang.Override
  public int getLabelsCount() {
    return labels_.size();
  }
  /**
   *
   *
   * <pre>
   * The set of labels that are available to describe a specific log entry.
   * Runtime requests that contain labels not specified here are
   * considered invalid.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
   */
  @java.lang.Override
  public com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor getLabels(int index) {
    return labels_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The set of labels that are available to describe a specific log entry.
   * Runtime requests that contain labels not specified here are
   * considered invalid.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
   */
  @java.lang.Override
  public com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptorOrBuilder getLabelsOrBuilder(int index) {
    return labels_.get(index);
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * A human-readable description of this log. This information appears in
   * the documentation and can contain details.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString bs = (com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A human-readable description of this log. This information appears in
   * the documentation and can contain details.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString b =
          com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 4;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * The human-readable name for this log. This information appears on
   * the user interface and should be concise.
   * </pre>
   *
   * <code>string display_name = 4;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString bs = (com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The human-readable name for this log. This information appears on
   * the user interface and should be concise.
   * </pre>
   *
   * <code>string display_name = 4;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString b =
          com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < labels_.size(); i++) {
      output.writeMessage(2, labels_.get(i));
    }
    if (!getDescriptionBytes().isEmpty()) {
      com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    if (!getDisplayNameBytes().isEmpty()) {
      com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.writeString(output, 4, displayName_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    for (int i = 0; i < labels_.size(); i++) {
      size += com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream.computeMessageSize(2, labels_.get(i));
    }
    if (!getDescriptionBytes().isEmpty()) {
      size += com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    if (!getDisplayNameBytes().isEmpty()) {
      size += com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.computeStringSize(4, displayName_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor)) {
      return super.equals(obj);
    }
    com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor other = (com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getLabelsList().equals(other.getLabelsList())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getLabelsCount() > 0) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + getLabelsList().hashCode();
    }
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor parseFrom(java.nio.ByteBuffer data)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor parseFrom(
      java.nio.ByteBuffer data, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor parseFrom(com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString data)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor parseFrom(
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString data,
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor parseFrom(byte[] data)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor parseFrom(
      byte[] data, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor parseFrom(
      java.io.InputStream input, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor parseDelimitedFrom(
      java.io.InputStream input, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor parseFrom(com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor parseFrom(
      com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A description of a log type. Example in YAML format:
   *     - name: library.googleapis.com/activity_history
   *       description: The history of borrowing and returning library items.
   *       display_name: Activity
   *       labels:
   *       - key: /customer_id
   *         description: Identifier of a library customer
   * </pre>
   *
   * Protobuf type {@code google.api.LogDescriptor}
   */
  public static final class Builder extends com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.LogDescriptor)
      com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptorOrBuilder {
    public static final com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.aliyun.openservices.ons.shaded.com.google.api.LogProto.internal_static_google_api_LogDescriptor_descriptor;
    }

    @java.lang.Override
    protected com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.aliyun.openservices.ons.shaded.com.google.api.LogProto.internal_static_google_api_LogDescriptor_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor.class, com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor.Builder.class);
    }

    // Construct using com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getLabelsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      if (labelsBuilder_ == null) {
        labels_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        labelsBuilder_.clear();
      }
      description_ = "";

      displayName_ = "";

      return this;
    }

    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.aliyun.openservices.ons.shaded.com.google.api.LogProto.internal_static_google_api_LogDescriptor_descriptor;
    }

    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor getDefaultInstanceForType() {
      return com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor.getDefaultInstance();
    }

    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor build() {
      com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor buildPartial() {
      com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor result = new com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      if (labelsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          labels_ = java.util.Collections.unmodifiableList(labels_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.labels_ = labels_;
      } else {
        result.labels_ = labelsBuilder_.build();
      }
      result.description_ = description_;
      result.displayName_ = displayName_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.aliyun.openservices.ons.shaded.com.google.protobuf.Message other) {
      if (other instanceof com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor) {
        return mergeFrom((com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor other) {
      if (other == com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (labelsBuilder_ == null) {
        if (!other.labels_.isEmpty()) {
          if (labels_.isEmpty()) {
            labels_ = other.labels_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureLabelsIsMutable();
            labels_.addAll(other.labels_);
          }
          onChanged();
        }
      } else {
        if (!other.labels_.isEmpty()) {
          if (labelsBuilder_.isEmpty()) {
            labelsBuilder_.dispose();
            labelsBuilder_ = null;
            labels_ = other.labels_;
            bitField0_ = (bitField0_ & ~0x00000001);
            labelsBuilder_ =
                com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLabelsFieldBuilder()
                    : null;
          } else {
            labelsBuilder_.addAllMessages(other.labels_);
          }
        }
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name of the log. It must be less than 512 characters long and can
     * include the following characters: upper- and lower-case alphanumeric
     * characters [A-Za-z0-9], and punctuation characters including
     * slash, underscore, hyphen, period [/_-.].
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString bs = (com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the log. It must be less than 512 characters long and can
     * include the following characters: upper- and lower-case alphanumeric
     * characters [A-Za-z0-9], and punctuation characters including
     * slash, underscore, hyphen, period [/_-.].
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString b =
            com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the log. It must be less than 512 characters long and can
     * include the following characters: upper- and lower-case alphanumeric
     * characters [A-Za-z0-9], and punctuation characters including
     * slash, underscore, hyphen, period [/_-.].
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the log. It must be less than 512 characters long and can
     * include the following characters: upper- and lower-case alphanumeric
     * characters [A-Za-z0-9], and punctuation characters including
     * slash, underscore, hyphen, period [/_-.].
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the log. It must be less than 512 characters long and can
     * include the following characters: upper- and lower-case alphanumeric
     * characters [A-Za-z0-9], and punctuation characters including
     * slash, underscore, hyphen, period [/_-.].
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor> labels_ =
        java.util.Collections.emptyList();

    private void ensureLabelsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        labels_ = new java.util.ArrayList<com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor>(labels_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.aliyun.openservices.ons.shaded.com.google.protobuf.RepeatedFieldBuilderV3<
            com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor,
            com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor.Builder,
            com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptorOrBuilder>
        labelsBuilder_;

    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public java.util.List<com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor> getLabelsList() {
      if (labelsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(labels_);
      } else {
        return labelsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public int getLabelsCount() {
      if (labelsBuilder_ == null) {
        return labels_.size();
      } else {
        return labelsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor getLabels(int index) {
      if (labelsBuilder_ == null) {
        return labels_.get(index);
      } else {
        return labelsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public Builder setLabels(int index, com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor value) {
      if (labelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelsIsMutable();
        labels_.set(index, value);
        onChanged();
      } else {
        labelsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public Builder setLabels(int index, com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor.Builder builderForValue) {
      if (labelsBuilder_ == null) {
        ensureLabelsIsMutable();
        labels_.set(index, builderForValue.build());
        onChanged();
      } else {
        labelsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public Builder addLabels(com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor value) {
      if (labelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelsIsMutable();
        labels_.add(value);
        onChanged();
      } else {
        labelsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public Builder addLabels(int index, com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor value) {
      if (labelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelsIsMutable();
        labels_.add(index, value);
        onChanged();
      } else {
        labelsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public Builder addLabels(com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor.Builder builderForValue) {
      if (labelsBuilder_ == null) {
        ensureLabelsIsMutable();
        labels_.add(builderForValue.build());
        onChanged();
      } else {
        labelsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public Builder addLabels(int index, com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor.Builder builderForValue) {
      if (labelsBuilder_ == null) {
        ensureLabelsIsMutable();
        labels_.add(index, builderForValue.build());
        onChanged();
      } else {
        labelsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public Builder addAllLabels(
        java.lang.Iterable<? extends com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor> values) {
      if (labelsBuilder_ == null) {
        ensureLabelsIsMutable();
        com.aliyun.openservices.ons.shaded.com.google.protobuf.AbstractMessageLite.Builder.addAll(values, labels_);
        onChanged();
      } else {
        labelsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public Builder clearLabels() {
      if (labelsBuilder_ == null) {
        labels_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        labelsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public Builder removeLabels(int index) {
      if (labelsBuilder_ == null) {
        ensureLabelsIsMutable();
        labels_.remove(index);
        onChanged();
      } else {
        labelsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor.Builder getLabelsBuilder(int index) {
      return getLabelsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptorOrBuilder getLabelsOrBuilder(int index) {
      if (labelsBuilder_ == null) {
        return labels_.get(index);
      } else {
        return labelsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public java.util.List<? extends com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptorOrBuilder>
        getLabelsOrBuilderList() {
      if (labelsBuilder_ != null) {
        return labelsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(labels_);
      }
    }
    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor.Builder addLabelsBuilder() {
      return getLabelsFieldBuilder()
          .addBuilder(com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor.Builder addLabelsBuilder(int index) {
      return getLabelsFieldBuilder()
          .addBuilder(index, com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The set of labels that are available to describe a specific log entry.
     * Runtime requests that contain labels not specified here are
     * considered invalid.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public java.util.List<com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor.Builder> getLabelsBuilderList() {
      return getLabelsFieldBuilder().getBuilderList();
    }

    private com.aliyun.openservices.ons.shaded.com.google.protobuf.RepeatedFieldBuilderV3<
            com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor,
            com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor.Builder,
            com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptorOrBuilder>
        getLabelsFieldBuilder() {
      if (labelsBuilder_ == null) {
        labelsBuilder_ =
            new com.aliyun.openservices.ons.shaded.com.google.protobuf.RepeatedFieldBuilderV3<
                com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor,
                com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor.Builder,
                com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptorOrBuilder>(
                labels_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        labels_ = null;
      }
      return labelsBuilder_;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * A human-readable description of this log. This information appears in
     * the documentation and can contain details.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString bs = (com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A human-readable description of this log. This information appears in
     * the documentation and can contain details.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString b =
            com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A human-readable description of this log. This information appears in
     * the documentation and can contain details.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A human-readable description of this log. This information appears in
     * the documentation and can contain details.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A human-readable description of this log. This information appears in
     * the documentation and can contain details.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The human-readable name for this log. This information appears on
     * the user interface and should be concise.
     * </pre>
     *
     * <code>string display_name = 4;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString bs = (com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The human-readable name for this log. This information appears on
     * the user interface and should be concise.
     * </pre>
     *
     * <code>string display_name = 4;</code>
     *
     * @return The bytes for displayName.
     */
    public com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString b =
            com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The human-readable name for this log. This information appears on
     * the user interface and should be concise.
     * </pre>
     *
     * <code>string display_name = 4;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The human-readable name for this log. This information appears on
     * the user interface and should be concise.
     * </pre>
     *
     * <code>string display_name = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The human-readable name for this log. This information appears on
     * the user interface and should be concise.
     * </pre>
     *
     * <code>string display_name = 4;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.LogDescriptor)
  }

  // @@protoc_insertion_point(class_scope:google.api.LogDescriptor)
  private static final com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor();
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.aliyun.openservices.ons.shaded.com.google.protobuf.Parser<LogDescriptor> PARSER =
      new com.aliyun.openservices.ons.shaded.com.google.protobuf.AbstractParser<LogDescriptor>() {
        @java.lang.Override
        public LogDescriptor parsePartialFrom(
            com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
            com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
          return new LogDescriptor(input, extensionRegistry);
        }
      };

  public static com.aliyun.openservices.ons.shaded.com.google.protobuf.Parser<LogDescriptor> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.aliyun.openservices.ons.shaded.com.google.protobuf.Parser<LogDescriptor> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.aliyun.openservices.ons.shaded.com.google.api.LogDescriptor getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
