/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/monitored_resource.proto

package com.aliyun.openservices.ons.shaded.com.google.api;

public interface MonitoredResourceDescriptorOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.api.MonitoredResourceDescriptor)
    com.aliyun.openservices.ons.shaded.com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Optional. The resource name of the monitored resource descriptor:
   * `"projects/{project_id}/monitoredResourceDescriptors/{type}"` where
   * {type} is the value of the `type` field in this object and
   * {project_id} is a project ID that provides API-specific context for
   * accessing the type.  APIs that do not use project information can use the
   * resource name format `"monitoredResourceDescriptors/{type}"`.
   * </pre>
   *
   * <code>string name = 5;</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Optional. The resource name of the monitored resource descriptor:
   * `"projects/{project_id}/monitoredResourceDescriptors/{type}"` where
   * {type} is the value of the `type` field in this object and
   * {project_id} is a project ID that provides API-specific context for
   * accessing the type.  APIs that do not use project information can use the
   * resource name format `"monitoredResourceDescriptors/{type}"`.
   * </pre>
   *
   * <code>string name = 5;</code>
   *
   * @return The bytes for name.
   */
  com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Required. The monitored resource type. For example, the type
   * `cloudsql_database` represents databases in Google Cloud SQL.
   * All service defined monitored resource types must be prefixed with the
   * service name, in the format of `{service name}/{relative resource name}`.
   * The relative resource name must follow:
   * * Only upper and lower-case letters and digits are allowed.
   * * It must start with upper case character and is recommended to use Upper
   *   Camel Case style.
   * * The maximum number of characters allowed for the relative_resource_name
   *   is 100.
   * Note there are legacy service monitored resources not following this rule.
   * </pre>
   *
   * <code>string type = 1;</code>
   *
   * @return The type.
   */
  java.lang.String getType();
  /**
   *
   *
   * <pre>
   * Required. The monitored resource type. For example, the type
   * `cloudsql_database` represents databases in Google Cloud SQL.
   * All service defined monitored resource types must be prefixed with the
   * service name, in the format of `{service name}/{relative resource name}`.
   * The relative resource name must follow:
   * * Only upper and lower-case letters and digits are allowed.
   * * It must start with upper case character and is recommended to use Upper
   *   Camel Case style.
   * * The maximum number of characters allowed for the relative_resource_name
   *   is 100.
   * Note there are legacy service monitored resources not following this rule.
   * </pre>
   *
   * <code>string type = 1;</code>
   *
   * @return The bytes for type.
   */
  com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString getTypeBytes();

  /**
   *
   *
   * <pre>
   * Optional. A concise name for the monitored resource type that might be
   * displayed in user interfaces. It should be a Title Cased Noun Phrase,
   * without any article or other determiners. For example,
   * `"Google Cloud SQL Database"`.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  java.lang.String getDisplayName();
  /**
   *
   *
   * <pre>
   * Optional. A concise name for the monitored resource type that might be
   * displayed in user interfaces. It should be a Title Cased Noun Phrase,
   * without any article or other determiners. For example,
   * `"Google Cloud SQL Database"`.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString getDisplayNameBytes();

  /**
   *
   *
   * <pre>
   * Optional. A detailed description of the monitored resource type that might
   * be used in documentation.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  java.lang.String getDescription();
  /**
   *
   *
   * <pre>
   * Optional. A detailed description of the monitored resource type that might
   * be used in documentation.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString getDescriptionBytes();

  /**
   *
   *
   * <pre>
   * Required. A set of labels used to describe instances of this monitored
   * resource type.
   * The label key name must follow:
   * * Only upper and lower-case letters, digits and underscores (_) are
   *   allowed.
   * * Label name must start with a letter or digit.
   * * The maximum length of a label name is 100 characters.
   * For example, an individual Google Cloud SQL database is
   * identified by values for the labels `database_id` and `location`.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
   */
  java.util.List<com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor> getLabelsList();
  /**
   *
   *
   * <pre>
   * Required. A set of labels used to describe instances of this monitored
   * resource type.
   * The label key name must follow:
   * * Only upper and lower-case letters, digits and underscores (_) are
   *   allowed.
   * * Label name must start with a letter or digit.
   * * The maximum length of a label name is 100 characters.
   * For example, an individual Google Cloud SQL database is
   * identified by values for the labels `database_id` and `location`.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
   */
  com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor getLabels(int index);
  /**
   *
   *
   * <pre>
   * Required. A set of labels used to describe instances of this monitored
   * resource type.
   * The label key name must follow:
   * * Only upper and lower-case letters, digits and underscores (_) are
   *   allowed.
   * * Label name must start with a letter or digit.
   * * The maximum length of a label name is 100 characters.
   * For example, an individual Google Cloud SQL database is
   * identified by values for the labels `database_id` and `location`.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
   */
  int getLabelsCount();
  /**
   *
   *
   * <pre>
   * Required. A set of labels used to describe instances of this monitored
   * resource type.
   * The label key name must follow:
   * * Only upper and lower-case letters, digits and underscores (_) are
   *   allowed.
   * * Label name must start with a letter or digit.
   * * The maximum length of a label name is 100 characters.
   * For example, an individual Google Cloud SQL database is
   * identified by values for the labels `database_id` and `location`.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
   */
  java.util.List<? extends com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptorOrBuilder> getLabelsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Required. A set of labels used to describe instances of this monitored
   * resource type.
   * The label key name must follow:
   * * Only upper and lower-case letters, digits and underscores (_) are
   *   allowed.
   * * Label name must start with a letter or digit.
   * * The maximum length of a label name is 100 characters.
   * For example, an individual Google Cloud SQL database is
   * identified by values for the labels `database_id` and `location`.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
   */
  com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptorOrBuilder getLabelsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Optional. The launch stage of the monitored resource definition.
   * </pre>
   *
   * <code>.google.api.LaunchStage launch_stage = 7;</code>
   *
   * @return The enum numeric value on the wire for launchStage.
   */
  int getLaunchStageValue();
  /**
   *
   *
   * <pre>
   * Optional. The launch stage of the monitored resource definition.
   * </pre>
   *
   * <code>.google.api.LaunchStage launch_stage = 7;</code>
   *
   * @return The launchStage.
   */
  com.aliyun.openservices.ons.shaded.com.google.api.LaunchStage getLaunchStage();
}
