/*
 * Copyright 2015 The gRPC Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.aliyun.openservices.ons.shaded.io.grpc;

import java.io.IOException;
import java.io.InputStream;

/**
 * Represents a message decompressor.
 */
@ExperimentalApi("https://github.com/grpc/grpc-java/issues/1704")
public interface Decompressor {
  /**
   * Returns the message encoding that this compressor uses.
   *
   * <p>This can be values such as "gzip", "deflate", "snappy", etc.
   */
  String getMessageEncoding();

  /**
   * Wraps an existing input stream with a decompressing input stream.
   * @param is The input stream of uncompressed data
   * @return An input stream that decompresses
   */
  InputStream decompress(InputStream is) throws IOException;
}

