/*
 * Copyright The OpenTelemetry Authors
 * SPDX-License-Identifier: Apache-2.0
 */

package com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics;


import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.common.Consumer;

/** Builder class for {@link DoubleSumObserver}. */
public interface DoubleSumObserverBuilder
    extends AsynchronousInstrumentBuilder<AsynchronousInstrument.DoubleResult> {
  @Override
  DoubleSumObserverBuilder setDescription(String description);

  @Override
  DoubleSumObserverBuilder setUnit(String unit);

  @Override
  DoubleSumObserverBuilder setUpdater(Consumer<AsynchronousInstrument.DoubleResult> updater);

  @Override
  DoubleSumObserver build();
}
