/*
 * Copyright The OpenTelemetry Authors
 * SPDX-License-Identifier: Apache-2.0
 */

package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.common.Labels;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.aggregator.AggregatorHandle;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.MetricData;
import java.util.List;

abstract class AbstractSynchronousInstrument extends AbstractInstrument {
  private final SynchronousInstrumentAccumulator<?> accumulator;

  AbstractSynchronousInstrument(
      InstrumentDescriptor descriptor, SynchronousInstrumentAccumulator<?> accumulator) {
    super(descriptor);
    this.accumulator = accumulator;
  }

  @Override
  final List<MetricData> collectAll(long epochNanos) {
    return accumulator.collectAll(epochNanos);
  }

  AggregatorHandle<?> acquireHandle(Labels labels) {
    return accumulator.bind(labels);
  }
}
