/*
 * Copyright The OpenTelemetry Authors
 * SPDX-License-Identifier: Apache-2.0
 */

package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.DoubleSumObserver;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.DoubleSumObserverBuilder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.common.BiFunction;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.common.InstrumentType;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.common.InstrumentValueType;

final class DoubleSumObserverSdk extends AbstractAsynchronousInstrument
    implements DoubleSumObserver {

  DoubleSumObserverSdk(
      InstrumentDescriptor descriptor, AsynchronousInstrumentAccumulator accumulator) {
    super(descriptor, accumulator);
  }

  static final class Builder
      extends AbstractDoubleAsynchronousInstrumentBuilder<DoubleSumObserverSdk.Builder>
      implements DoubleSumObserverBuilder {

    Builder(
        String name,
        MeterProviderSharedState meterProviderSharedState,
        MeterSharedState meterSharedState) {
      super(
          name,
          InstrumentType.SUM_OBSERVER,
          InstrumentValueType.DOUBLE,
          meterProviderSharedState,
          meterSharedState);
    }

    @Override
    Builder getThis() {
      return this;
    }

    @Override
    public DoubleSumObserverSdk build() {
      return buildInstrument(
          new BiFunction<InstrumentDescriptor, AsynchronousInstrumentAccumulator, DoubleSumObserverSdk>() {
            @Override
            public DoubleSumObserverSdk apply(InstrumentDescriptor instrumentDescriptor,
                AsynchronousInstrumentAccumulator asynchronousInstrumentAccumulator) {
              return new DoubleSumObserverSdk(instrumentDescriptor, asynchronousInstrumentAccumulator);
            }
          });
    }
  }
}
