/*
 * Copyright The OpenTelemetry Authors
 * SPDX-License-Identifier: Apache-2.0
 */

package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data;

import com.aliyun.openservices.ons.shaded.com.google.auto.value.AutoValue;
import java.util.Collection;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class LongSumData implements SumData<LongPointData> {
  public static LongSumData create(
      boolean isMonotonic, AggregationTemporality temporality, Collection<LongPointData> points) {
    return new AutoValue_LongSumData(points, isMonotonic, temporality);
  }

  LongSumData() {}
}
