/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api;

import com.aliyun.openservices.ons.api.SystemProperties;
import com.aliyun.openservices.ons.api.TopicPartition;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.MessageIdGenerator;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.utility.UtilAll;
import java.io.Serializable;
import java.util.Properties;

public class Message
implements Serializable {
    private static final long serialVersionUID = -1385924226856188094L;
    final SystemProperties systemProperties;
    private String topic;
    private Properties userProperties;
    private byte[] body;

    @Deprecated
    public Message() {
        this(null, "", "", null);
    }

    public Message(String topic, String tag, byte[] body) {
        this(topic, tag, "", body);
    }

    public Message(String topic, String tag, String key, byte[] body) {
        this.topic = topic;
        this.body = (byte[])(null != body ? (byte[])body.clone() : null);
        this.userProperties = new Properties();
        this.systemProperties = new SystemProperties();
        this.systemProperties.setTag(tag);
        this.systemProperties.setKey(key);
        this.systemProperties.setBornHost(UtilAll.hostName());
        this.reset();
    }

    Message(String topic, byte[] body, SystemProperties systemProperties, Properties userProperties) {
        this.topic = topic;
        this.body = body;
        this.systemProperties = systemProperties;
        this.userProperties = userProperties;
    }

    public void putUserProperties(String key, String value) {
        if (key != null && value != null) {
            this.userProperties.put(key, value);
            this.reset();
        }
    }

    public String getUserProperties(String key) {
        return (String)this.userProperties.get(key);
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
        this.reset();
    }

    public String getTag() {
        return this.systemProperties.getTag();
    }

    public void setTag(String tag) {
        this.systemProperties.setTag(tag);
        this.reset();
    }

    public String getKey() {
        return this.systemProperties.getKey();
    }

    public void setKey(String key) {
        this.systemProperties.setKey(key);
        this.reset();
    }

    public String getMsgID() {
        return this.systemProperties.getMsgId();
    }

    @Deprecated
    public void setMsgID(String msgId) {
    }

    public Properties getUserProperties() {
        return this.userProperties;
    }

    public void setUserProperties(Properties userProperties) {
        this.userProperties = userProperties;
        this.reset();
    }

    public byte[] getBody() {
        if (null == this.body) {
            return null;
        }
        return (byte[])this.body.clone();
    }

    public void setBody(byte[] body) {
        if (null == body) {
            this.body = null;
            return;
        }
        this.body = (byte[])body.clone();
        this.reset();
    }

    public int getReconsumeTimes() {
        return this.systemProperties.getReconsumeTimes();
    }

    @Deprecated
    public void setReconsumeTimes(int reconsumeTimes) {
    }

    public long getBornTimestamp() {
        return this.systemProperties.getBornTimestamp();
    }

    @Deprecated
    public void setBornTimestamp(long bornTimestamp) {
    }

    public String getBornHost() {
        return this.systemProperties.getBornHost();
    }

    @Deprecated
    public void setBornHost(String bornHost) {
    }

    public long getStartDeliverTime() {
        return this.systemProperties.getStartDeliverTime();
    }

    public String getShardingKey() {
        return this.systemProperties.getShardingKey();
    }

    public void setShardingKey(String shardingKey) {
        this.systemProperties.setShardingKey(shardingKey);
        this.reset();
    }

    public void setStartDeliverTime(long startDeliverTime) {
        this.systemProperties.setStartDeliverTime(startDeliverTime);
        this.reset();
    }

    public long getOffset() {
        return this.systemProperties.getPartitionOffset();
    }

    private void reset() {
        this.systemProperties.setBornTimestamp(System.currentTimeMillis());
        this.systemProperties.setMsgId(MessageIdGenerator.getInstance().next());
    }

    @Deprecated
    public TopicPartition getTopicPartition() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "Message [topic=" + this.topic + ", systemProperties=" + this.systemProperties + ", userProperties=" + this.userProperties + ", bodyLength=" + (this.body != null ? this.body.length : 0) + "]";
    }
}

