/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.client;

import com.aliyun.openservices.ons.api.Admin;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.aliyun.openservices.ons.client.utils.UtilAll;
import com.aliyun.openservices.ons.shaded.commons.lang3.StringUtils;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.remoting.CredentialsProvider;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.remoting.StaticCredentialsProvider;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.remoting.StsCredentialsProvider;
import com.aliyun.openservices.ons.shaded.org.slf4j.Logger;
import com.aliyun.openservices.ons.shaded.org.slf4j.LoggerFactory;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class ClientAbstract
implements Admin {
    private static final Logger log = LoggerFactory.getLogger(ClientAbstract.class);
    private static final String TRACE_ON = "true";
    protected CredentialsProvider provider;
    protected String namespace = null;
    protected final String nameServerAddr;
    protected final AtomicBoolean started = new AtomicBoolean(false);
    protected final boolean messageTracingEnabled;

    public ClientAbstract(Properties properties) {
        String ramRole;
        String namespaceProps = properties.getProperty("INSTANCE_ID");
        if (StringUtils.isNoneBlank(namespaceProps)) {
            this.namespace = namespaceProps;
        }
        if (StringUtils.isNotBlank(ramRole = properties.getProperty("RamRoleName"))) {
            log.info("Ram role was set.");
            this.provider = new StsCredentialsProvider(ramRole);
        } else {
            log.debug("Ram role was not set, using AccessKey/SecretKey/SecurityToken instead.");
            String accessKey = properties.getProperty("AccessKey");
            String secretKey = properties.getProperty("SecretKey");
            String securityToken = properties.getProperty("SecurityToken");
            if (StringUtils.isBlank(accessKey)) {
                throw new ONSClientException("AccessKey is blank unexpectedly, please set it.");
            }
            if (StringUtils.isBlank(secretKey)) {
                throw new ONSClientException("SecretKey is blank unexpectedly, please set it.");
            }
            this.provider = StringUtils.isBlank(securityToken) ? new StaticCredentialsProvider(accessKey, secretKey) : new StaticCredentialsProvider(accessKey, secretKey, securityToken);
        }
        String nameServerAddr = properties.getProperty("NAMESRV_ADDR");
        if (!UtilAll.validateNameServerEndpoint(nameServerAddr)) {
            throw new ONSClientException("Name server address is illegal.");
        }
        this.nameServerAddr = nameServerAddr;
        this.messageTracingEnabled = Boolean.parseBoolean(properties.getProperty("MsgTraceSwitch", TRACE_ON));
    }

    @Override
    public boolean isStarted() {
        return this.started.get();
    }

    @Override
    public boolean isClosed() {
        return !this.isStarted();
    }

    @Override
    public void updateCredential(Properties credentialProperties) {
        String accessKey = credentialProperties.getProperty("AccessKey");
        String secretKey = credentialProperties.getProperty("SecretKey");
        String securityToken = credentialProperties.getProperty("SecurityToken");
        if (StringUtils.isBlank(accessKey)) {
            throw new ONSClientException("update credential failed. please set access key.");
        }
        if (StringUtils.isBlank(secretKey)) {
            throw new ONSClientException("update credential failed. please set secret key");
        }
        if (StringUtils.isBlank(securityToken)) {
            this.provider = new StaticCredentialsProvider(accessKey, secretKey);
            return;
        }
        this.provider = new StaticCredentialsProvider(accessKey, secretKey, securityToken);
    }
}

