/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.client.rocketmq.impl;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.MessageSelector;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.aliyun.openservices.ons.client.rocketmq.PushConsumer;
import com.aliyun.openservices.ons.client.utils.UtilAll;
import com.aliyun.openservices.ons.shaded.commons.lang3.StringUtils;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.consumer.ConsumeContext;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.consumer.ConsumeStatus;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.MessageExt;
import com.aliyun.openservices.ons.shaded.org.slf4j.Logger;
import com.aliyun.openservices.ons.shaded.org.slf4j.LoggerFactory;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class PushConsumerImpl
extends PushConsumer
implements Consumer {
    private static final Logger log = LoggerFactory.getLogger(PushConsumerImpl.class);
    private final ConcurrentMap<String, MessageListener> subscribeTable = new ConcurrentHashMap<String, MessageListener>();

    public PushConsumerImpl(Properties properties) {
        super(properties);
    }

    @Override
    public void start() {
        this.defaultMQPushConsumer.registerMessageListener(new MessageListenerImpl());
        log.info("Register message listener successfully.");
        super.start();
    }

    @Override
    public void subscribe(String topic, String subExpression, MessageListener listener) {
        MessageSelector selector = MessageSelector.byTag(subExpression);
        this.subscribe(topic, selector, listener);
    }

    @Override
    public void subscribe(String topic, MessageSelector selector, MessageListener listener) {
        if (StringUtils.isBlank(topic)) {
            throw new ONSClientException("Topic is blank unexpectedly, please set it.");
        }
        if (null == listener) {
            throw new ONSClientException("Listener is null, please set it.");
        }
        this.subscribeTable.put(topic, listener);
        super.subscribe(topic, selector);
    }

    @Override
    public void rateLimit(String topic, double permitsPerSecond) {
        this.defaultMQPushConsumer.rateLimit(topic, permitsPerSecond);
    }

    @Override
    public void unsubscribe(String topic) {
        if (StringUtils.isBlank(topic)) {
            return;
        }
        this.subscribeTable.remove(topic);
        super.unsubscribe(topic);
    }

    class MessageListenerImpl
    extends MessageListenerConcurrently {
        MessageListenerImpl() {
        }

        @Override
        public ConsumeStatus consume(List<MessageExt> msgList, ConsumeContext consumeContext) {
            MessageExt rmqMessageExt = msgList.get(0);
            Message message = UtilAll.msgConvert(rmqMessageExt);
            String topic = message.getTopic();
            MessageListener messageListener = (MessageListener)PushConsumerImpl.this.subscribeTable.get(topic);
            if (null == messageListener) {
                log.error("MessageListener is null, subscribeTable topics={}, messageExt={}", (Object)PushConsumerImpl.this.subscribeTable.keySet(), (Object)rmqMessageExt);
                throw new ONSClientException("MessageListener is null.");
            }
            com.aliyun.openservices.ons.api.ConsumeContext context = new com.aliyun.openservices.ons.api.ConsumeContext();
            Action action = messageListener.consume(message, context);
            if (null == action) {
                return null;
            }
            switch (action) {
                case CommitMessage: {
                    return ConsumeStatus.OK;
                }
            }
            return ConsumeStatus.ERROR;
        }
    }
}

