/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.exporter.otlp.trace;

import com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.common.AttributeKey;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.common.Attributes;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.internal.BiConsumer;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.exporter.otlp.trace.MarshalerUtil;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.exporter.otlp.trace.MarshalerWithSize;
import java.io.IOException;
import java.util.List;

abstract class AttributeMarshaler
extends MarshalerWithSize {
    private static final AttributeMarshaler[] EMPTY_REPEATED = new AttributeMarshaler[0];
    private final byte[] key;
    private final int valueSize;

    static AttributeMarshaler[] createRepeated(Attributes attributes) {
        if (attributes.isEmpty()) {
            return EMPTY_REPEATED;
        }
        final AttributeMarshaler[] attributeMarshalers = new AttributeMarshaler[attributes.size()];
        attributes.forEach(new BiConsumer<AttributeKey<?>, Object>(){
            int index = 0;

            @Override
            public void accept(AttributeKey<?> attributeKey, Object o) {
                attributeMarshalers[this.index++] = AttributeMarshaler.create(attributeKey, o);
            }
        });
        return attributeMarshalers;
    }

    static AttributeMarshaler create(AttributeKey<?> attributeKey, Object value) {
        byte[] key = MarshalerUtil.toBytes(attributeKey.getKey());
        if (value == null) {
            return new KeyValueNullMarshaler(key);
        }
        switch (attributeKey.getType()) {
            case STRING: {
                return new KeyValueStringMarshaler(key, MarshalerUtil.toBytes((String)value));
            }
            case LONG: {
                return new KeyValueLongMarshaler(key, (Long)value);
            }
            case BOOLEAN: {
                return new KeyValueBooleanMarshaler(key, (Boolean)value);
            }
            case DOUBLE: {
                return new KeyValueDoubleMarshaler(key, (Double)value);
            }
            case STRING_ARRAY: {
                return new KeyValueArrayStringMarshaler(key, (List)value);
            }
            case LONG_ARRAY: {
                return new KeyValueArrayLongMarshaler(key, (List)value);
            }
            case BOOLEAN_ARRAY: {
                return new KeyValueArrayBooleanMarshaler(key, (List)value);
            }
            case DOUBLE_ARRAY: {
                return new KeyValueArrayDoubleMarshaler(key, (List)value);
            }
        }
        throw new IllegalArgumentException("Unsupported attribute type.");
    }

    private AttributeMarshaler(byte[] key, int valueSize) {
        super(AttributeMarshaler.calculateSize(key, valueSize));
        this.key = key;
        this.valueSize = valueSize;
    }

    @Override
    public final void writeTo(CodedOutputStream output) throws IOException {
        MarshalerUtil.marshalBytes(1, this.key, output);
        if (this.valueSize > 0) {
            output.writeTag(2, 2);
            output.writeUInt32NoTag(this.valueSize);
            this.writeValueTo(output);
        }
    }

    abstract void writeValueTo(CodedOutputStream var1) throws IOException;

    private static int calculateSize(byte[] key, int valueSize) {
        return MarshalerUtil.sizeBytes(1, key) + CodedOutputStream.computeTagSize(2) + CodedOutputStream.computeUInt32SizeNoTag(valueSize) + valueSize;
    }

    private static final class KeyValueArrayDoubleMarshaler
    extends KeyValueArrayMarshaler<Double> {
        private KeyValueArrayDoubleMarshaler(byte[] key, List<Double> values) {
            super(key, values, KeyValueArrayDoubleMarshaler.calculateValuesSize(values));
        }

        @Override
        void writeArrayElementTo(Double value, CodedOutputStream output) throws IOException {
            output.writeDouble(4, value);
        }

        @Override
        int getArrayElementSerializedSize(Double value) {
            return CodedOutputStream.computeDoubleSize(4, value);
        }

        static int calculateValuesSize(List<Double> values) {
            int size = 0;
            int fieldTagSize = CodedOutputStream.computeTagSize(1);
            for (Double value : values) {
                int fieldSize = CodedOutputStream.computeDoubleSize(4, value);
                size += fieldTagSize + CodedOutputStream.computeUInt32SizeNoTag(fieldSize) + fieldSize;
            }
            return size;
        }
    }

    private static final class KeyValueArrayBooleanMarshaler
    extends KeyValueArrayMarshaler<Boolean> {
        private KeyValueArrayBooleanMarshaler(byte[] key, List<Boolean> values) {
            super(key, values, KeyValueArrayBooleanMarshaler.calculateValuesSize(values));
        }

        @Override
        void writeArrayElementTo(Boolean value, CodedOutputStream output) throws IOException {
            output.writeBool(2, value);
        }

        @Override
        int getArrayElementSerializedSize(Boolean value) {
            return CodedOutputStream.computeBoolSize(2, value);
        }

        static int calculateValuesSize(List<Boolean> values) {
            int size = 0;
            int fieldTagSize = CodedOutputStream.computeTagSize(1);
            for (Boolean value : values) {
                int fieldSize = CodedOutputStream.computeBoolSize(2, value);
                size += fieldTagSize + CodedOutputStream.computeUInt32SizeNoTag(fieldSize) + fieldSize;
            }
            return size;
        }
    }

    private static final class KeyValueArrayLongMarshaler
    extends KeyValueArrayMarshaler<Long> {
        private KeyValueArrayLongMarshaler(byte[] key, List<Long> values) {
            super(key, values, KeyValueArrayLongMarshaler.calculateValuesSize(values));
        }

        @Override
        void writeArrayElementTo(Long value, CodedOutputStream output) throws IOException {
            output.writeInt64(3, value);
        }

        @Override
        int getArrayElementSerializedSize(Long value) {
            return CodedOutputStream.computeInt64Size(3, value);
        }

        static int calculateValuesSize(List<Long> values) {
            int size = 0;
            int fieldTagSize = CodedOutputStream.computeTagSize(1);
            for (Long value : values) {
                int fieldSize = CodedOutputStream.computeInt64Size(3, value);
                size += fieldTagSize + CodedOutputStream.computeUInt32SizeNoTag(fieldSize) + fieldSize;
            }
            return size;
        }
    }

    private static final class KeyValueArrayStringMarshaler
    extends KeyValueArrayMarshaler<String> {
        private KeyValueArrayStringMarshaler(byte[] key, List<String> values) {
            super(key, values, KeyValueArrayStringMarshaler.calculateValuesSize(values));
        }

        @Override
        void writeArrayElementTo(String value, CodedOutputStream output) throws IOException {
            output.writeString(1, value);
        }

        @Override
        int getArrayElementSerializedSize(String value) {
            return CodedOutputStream.computeStringSize(1, value);
        }

        static int calculateValuesSize(List<String> values) {
            int size = 0;
            int fieldTagSize = CodedOutputStream.computeTagSize(1);
            for (String value : values) {
                int fieldSize = CodedOutputStream.computeStringSize(1, value);
                size += fieldTagSize + CodedOutputStream.computeUInt32SizeNoTag(fieldSize) + fieldSize;
            }
            return size;
        }
    }

    private static abstract class KeyValueArrayMarshaler<T>
    extends AttributeMarshaler {
        private final List<T> values;
        private final int valuesSize;

        private KeyValueArrayMarshaler(byte[] key, List<T> values, int valuesSize) {
            super(key, KeyValueArrayMarshaler.calculateWrapperSize(valuesSize) + valuesSize);
            this.values = values;
            this.valuesSize = valuesSize;
        }

        @Override
        public final void writeValueTo(CodedOutputStream output) throws IOException {
            output.writeTag(5, 2);
            output.writeUInt32NoTag(this.valuesSize);
            for (T value : this.values) {
                output.writeTag(1, 2);
                output.writeUInt32NoTag(this.getArrayElementSerializedSize(value));
                this.writeArrayElementTo(value, output);
            }
        }

        abstract void writeArrayElementTo(T var1, CodedOutputStream var2) throws IOException;

        abstract int getArrayElementSerializedSize(T var1);

        private static int calculateWrapperSize(int valuesSize) {
            return CodedOutputStream.computeTagSize(5) + CodedOutputStream.computeUInt32SizeNoTag(valuesSize);
        }
    }

    private static final class KeyValueDoubleMarshaler
    extends AttributeMarshaler {
        private final double value;

        private KeyValueDoubleMarshaler(byte[] key, double value) {
            super(key, CodedOutputStream.computeDoubleSize(4, value));
            this.value = value;
        }

        @Override
        public void writeValueTo(CodedOutputStream output) throws IOException {
            output.writeDouble(4, this.value);
        }
    }

    private static final class KeyValueBooleanMarshaler
    extends AttributeMarshaler {
        private final boolean value;

        private KeyValueBooleanMarshaler(byte[] key, boolean value) {
            super(key, CodedOutputStream.computeBoolSize(2, value));
            this.value = value;
        }

        @Override
        public void writeValueTo(CodedOutputStream output) throws IOException {
            output.writeBool(2, this.value);
        }
    }

    private static final class KeyValueLongMarshaler
    extends AttributeMarshaler {
        private final long value;

        private KeyValueLongMarshaler(byte[] key, long value) {
            super(key, CodedOutputStream.computeInt64Size(3, value));
            this.value = value;
        }

        @Override
        public void writeValueTo(CodedOutputStream output) throws IOException {
            output.writeInt64(3, this.value);
        }
    }

    private static final class KeyValueStringMarshaler
    extends AttributeMarshaler {
        private final byte[] value;

        private KeyValueStringMarshaler(byte[] key, byte[] value) {
            super(key, CodedOutputStream.computeByteArraySize(1, value));
            this.value = value;
        }

        @Override
        public void writeValueTo(CodedOutputStream output) throws IOException {
            output.writeByteArray(1, this.value);
        }
    }

    private static final class KeyValueNullMarshaler
    extends AttributeMarshaler {
        private KeyValueNullMarshaler(byte[] key) {
            super(key, 0);
        }

        @Override
        void writeValueTo(CodedOutputStream output) {
        }
    }
}

