/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.exporter.otlp.trace;

import com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.exporter.otlp.trace.MarshalerUtil;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.exporter.otlp.trace.MarshalerWithSize;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import java.io.IOException;

final class InstrumentationLibraryMarshaler
extends MarshalerWithSize {
    private final byte[] name;
    private final byte[] version;

    static InstrumentationLibraryMarshaler create(InstrumentationLibraryInfo libraryInfo) {
        byte[] name = MarshalerUtil.toBytes(libraryInfo.getName());
        byte[] version = MarshalerUtil.toBytes(libraryInfo.getVersion());
        return new InstrumentationLibraryMarshaler(name, version);
    }

    private InstrumentationLibraryMarshaler(byte[] name, byte[] version) {
        super(InstrumentationLibraryMarshaler.computeSize(name, version));
        this.name = name;
        this.version = version;
    }

    @Override
    public void writeTo(CodedOutputStream output) throws IOException {
        MarshalerUtil.marshalBytes(1, this.name, output);
        MarshalerUtil.marshalBytes(2, this.version, output);
    }

    private static int computeSize(byte[] name, byte[] version) {
        return MarshalerUtil.sizeBytes(1, name) + MarshalerUtil.sizeBytes(2, version);
    }
}

