/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.common.Labels;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.context.Context;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.AbstractAccumulator;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.InstrumentProcessor;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.MeterSharedState;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.aggregator.AggregatorHandle;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.MetricData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.processor.LabelsProcessor;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

final class SynchronousInstrumentAccumulator<T>
extends AbstractAccumulator {
    private final ConcurrentHashMap<Labels, AggregatorHandle<T>> aggregatorLabels = new ConcurrentHashMap();
    private final ReentrantLock collectLock = new ReentrantLock();
    private final Aggregator<T> aggregator;
    private final InstrumentProcessor<T> instrumentProcessor;
    private final LabelsProcessor labelsProcessor;

    static <T> SynchronousInstrumentAccumulator<T> create(MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, InstrumentDescriptor descriptor) {
        Aggregator aggregator = SynchronousInstrumentAccumulator.getAggregator(meterProviderSharedState, meterSharedState, descriptor);
        return new SynchronousInstrumentAccumulator(aggregator, new InstrumentProcessor(aggregator, meterProviderSharedState.getStartEpochNanos()), SynchronousInstrumentAccumulator.getLabelsProcessor(meterProviderSharedState, meterSharedState, descriptor));
    }

    SynchronousInstrumentAccumulator(Aggregator<T> aggregator, InstrumentProcessor<T> instrumentProcessor, LabelsProcessor labelsProcessor) {
        this.aggregator = aggregator;
        this.instrumentProcessor = instrumentProcessor;
        this.labelsProcessor = labelsProcessor;
    }

    AggregatorHandle<?> bind(Labels labels) {
        AggregatorHandle<T> boundAggregatorHandle;
        if (labels == null) {
            throw new NullPointerException("labels");
        }
        labels = this.labelsProcessor.onLabelsBound(Context.current(), labels);
        AggregatorHandle<T> aggregatorHandle = this.aggregatorLabels.get(labels);
        if (aggregatorHandle != null && aggregatorHandle.acquire()) {
            return aggregatorHandle;
        }
        aggregatorHandle = this.aggregator.createHandle();
        while ((boundAggregatorHandle = this.aggregatorLabels.putIfAbsent(labels, aggregatorHandle)) != null) {
            if (boundAggregatorHandle.acquire()) {
                return boundAggregatorHandle;
            }
            this.aggregatorLabels.remove(labels, boundAggregatorHandle);
        }
        return aggregatorHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<MetricData> collectAll(long epochNanos) {
        this.collectLock.lock();
        try {
            for (Map.Entry<Labels, AggregatorHandle<T>> entry : this.aggregatorLabels.entrySet()) {
                T accumulation;
                boolean unmappedEntry = entry.getValue().tryUnmap();
                if (unmappedEntry) {
                    this.aggregatorLabels.remove(entry.getKey(), entry.getValue());
                }
                if ((accumulation = entry.getValue().accumulateThenReset()) == null) continue;
                this.instrumentProcessor.batch(entry.getKey(), accumulation);
            }
            List<MetricData> list = this.instrumentProcessor.completeCollectionCycle(epochNanos);
            return list;
        }
        finally {
            this.collectLock.unlock();
        }
    }
}

