/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.ViewRegistryBuilder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.aggregator.AggregatorFactory;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.common.InstrumentType;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.view.View;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;

@Immutable
final class ViewRegistry {
    static final View CUMULATIVE_SUM = View.builder().setAggregatorFactory(AggregatorFactory.sum(AggregationTemporality.CUMULATIVE)).build();
    static final View SUMMARY = View.builder().setAggregatorFactory(AggregatorFactory.minMaxSumCount()).build();
    static final View LAST_VALUE = View.builder().setAggregatorFactory(AggregatorFactory.lastValue()).build();
    private final EnumMap<InstrumentType, LinkedHashMap<Pattern, View>> configuration = new EnumMap(InstrumentType.class);

    ViewRegistry(EnumMap<InstrumentType, LinkedHashMap<Pattern, View>> configuration) {
        for (Map.Entry<InstrumentType, LinkedHashMap<Pattern, View>> entry : configuration.entrySet()) {
            InstrumentType instrumentType = entry.getKey();
            LinkedHashMap<Pattern, View> patternViewLinkedHashMap = entry.getValue();
            this.configuration.put(instrumentType, new LinkedHashMap<Pattern, View>(patternViewLinkedHashMap));
        }
    }

    static ViewRegistryBuilder builder() {
        return new ViewRegistryBuilder();
    }

    View findView(InstrumentDescriptor descriptor) {
        LinkedHashMap<Pattern, View> configPerType = this.configuration.get((Object)descriptor.getType());
        for (Map.Entry<Pattern, View> entry : configPerType.entrySet()) {
            if (!entry.getKey().matcher(descriptor.getName()).matches()) continue;
            return entry.getValue();
        }
        return ViewRegistry.getDefaultSpecification(descriptor);
    }

    private static View getDefaultSpecification(InstrumentDescriptor descriptor) {
        switch (descriptor.getType()) {
            case COUNTER: 
            case UP_DOWN_COUNTER: 
            case SUM_OBSERVER: 
            case UP_DOWN_SUM_OBSERVER: {
                return CUMULATIVE_SUM;
            }
            case VALUE_RECORDER: {
                return SUMMARY;
            }
            case VALUE_OBSERVER: {
                return LAST_VALUE;
            }
        }
        throw new IllegalArgumentException("Unknown descriptor type: " + (Object)((Object)descriptor.getType()));
    }
}

