/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.aggregator;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.common.Labels;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.aggregator.AbstractAggregator;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.aggregator.AggregatorHandle;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.aggregator.MetricDataUtils;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.DoubleGaugeData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.MetricData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.resources.Resource;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class DoubleLastValueAggregator
extends AbstractAggregator<Double> {
    DoubleLastValueAggregator(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor descriptor) {
        super(resource, instrumentationLibraryInfo, descriptor, true);
    }

    @Override
    public AggregatorHandle<Double> createHandle() {
        return new Handle();
    }

    @Override
    public Double accumulateDouble(double value) {
        return value;
    }

    @Override
    public Double merge(Double a1, Double a2) {
        return a2;
    }

    @Override
    public MetricData toMetricData(Map<Labels, Double> accumulationByLabels, long startEpochNanos, long lastCollectionEpoch, long epochNanos) {
        return MetricData.createDoubleGauge(this.getResource(), this.getInstrumentationLibraryInfo(), this.getInstrumentDescriptor().getName(), this.getInstrumentDescriptor().getDescription(), this.getInstrumentDescriptor().getUnit(), DoubleGaugeData.create(MetricDataUtils.toDoublePointList(accumulationByLabels, 0L, epochNanos)));
    }

    static final class Handle
    extends AggregatorHandle<Double> {
        @Nullable
        private static final Double DEFAULT_VALUE = null;
        private final AtomicReference<Double> current = new AtomicReference<Double>(DEFAULT_VALUE);

        private Handle() {
        }

        @Override
        protected Double doAccumulateThenReset() {
            return this.current.getAndSet(DEFAULT_VALUE);
        }

        @Override
        protected void doRecordDouble(double value) {
            this.current.set(value);
        }
    }
}

