/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.aggregator;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.aggregator.AggregatorFactory;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.aggregator.DoubleLastValueAggregator;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.aggregator.LongLastValueAggregator;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.resources.Resource;

final class LastValueAggregatorFactory
extends AggregatorFactory {
    static final AggregatorFactory INSTANCE = new LastValueAggregatorFactory();

    private LastValueAggregatorFactory() {
    }

    @Override
    public <T> Aggregator<T> create(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor descriptor) {
        switch (descriptor.getValueType()) {
            case LONG: {
                return new LongLastValueAggregator(resource, instrumentationLibraryInfo, descriptor);
            }
            case DOUBLE: {
                return new DoubleLastValueAggregator(resource, instrumentationLibraryInfo, descriptor);
            }
        }
        throw new IllegalArgumentException("Invalid instrument value type");
    }
}

